/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.generator;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.spi.ddlgenerator.CreateTableSQLGenerator;
import org.apache.shardingsphere.data.pipeline.spi.ddlgenerator.CreateTableSQLGeneratorFactory;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CommentStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateIndexStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.binder.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDDLGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDDLGenerator.class);
    private static final String DELIMITER = ";";
    private static final String SET_SEARCH_PATH_PREFIX = "set search_path";
    private final ContextManager contextManager;

    public String generateLogicDDLSQL(DatabaseType databaseType, String databaseName, String schemaName, String tableName) {
        ShardingSphereDatabase database = (ShardingSphereDatabase)this.contextManager.getMetaDataContexts().getMetaData().getDatabases().get(databaseName);
        log.info("generateLogicDDLSQL, databaseType={}, databaseName={}, schemaName={}, tableName={}, dataSourceNames={}", new Object[]{databaseType.getType(), databaseName, schemaName, tableName, database.getResource().getDataSources().keySet()});
        String sql = this.generateActualDDLSQL(databaseType, schemaName, tableName, database);
        StringBuilder result = new StringBuilder();
        for (String each : sql.split(DELIMITER)) {
            Optional<String> logicSQL = this.decorate(databaseType, databaseName, schemaName, database, each);
            logicSQL.ifPresent(ddlSQL -> result.append((String)ddlSQL).append(DELIMITER).append(System.lineSeparator()));
        }
        return result.toString();
    }

    public String replaceTableNameWithPrefix(String sql, String prefix, DatabaseType databaseType, String databaseName) {
        LogicSQL logicSQL = this.getLogicSQL(sql, databaseType, databaseName);
        SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
        if ((sqlStatementContext instanceof CreateTableStatementContext || sqlStatementContext instanceof CommentStatementContext || sqlStatementContext instanceof CreateIndexStatementContext || sqlStatementContext instanceof AlterTableStatementContext) && !sqlStatementContext.getTablesContext().getTables().isEmpty()) {
            TableNameSegment tableNameSegment = ((SimpleTableSegment)sqlStatementContext.getTablesContext().getTables().iterator().next()).getTableName();
            TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
            replaceMap.put((SQLSegment)tableNameSegment, prefix + tableNameSegment.getIdentifier().getValue());
            return this.doDecorateActualTable(replaceMap, sql);
        }
        return sql;
    }

    private Optional<String> decorate(DatabaseType databaseType, String databaseName, String schemaName, ShardingSphereDatabase database, String sql) {
        if (sql.trim().isEmpty()) {
            return Optional.empty();
        }
        String result = this.decorateActualSQL(sql.trim(), database, databaseType, databaseName);
        if ("openGauss".equals(databaseType.getType())) {
            return this.decorateOpenGauss(databaseType, databaseName, schemaName, result);
        }
        return Optional.of(result);
    }

    private String generateActualDDLSQL(DatabaseType databaseType, String schemaName, String tableName, ShardingSphereDatabase database) throws SQLException {
        DataNodes dataNodes = new DataNodes(database.getRuleMetaData().getRules());
        Optional<DataNode> filteredDataNode = dataNodes.getDataNodes(tableName).stream().filter(each -> database.getResource().getDataSources().containsKey(each.getDataSourceName().contains(".") ? each.getDataSourceName().split("\\.")[0] : each.getDataSourceName())).findFirst();
        String dataSourceName = filteredDataNode.map(DataNode::getDataSourceName).orElseGet(() -> (String)database.getResource().getDataSources().keySet().iterator().next());
        String actualTable = filteredDataNode.map(DataNode::getTableName).orElse(tableName);
        return ((CreateTableSQLGenerator)CreateTableSQLGeneratorFactory.findInstance((DatabaseType)databaseType).orElseThrow(() -> new ShardingSphereException("Failed to get dialect ddl sql generator", new Object[0]))).generate(actualTable, schemaName, (DataSource)database.getResource().getDataSources().get(dataSourceName));
    }

    private String decorateActualSQL(String sql, ShardingSphereDatabase database, DatabaseType databaseType, String databaseName) {
        LogicSQL logicSQL = this.getLogicSQL(sql, databaseType, databaseName);
        SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
        TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
        if (sqlStatementContext instanceof CreateTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, database, sqlStatementContext);
            this.appendFromTable(replaceMap, database, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CommentStatementContext) {
            this.appendFromTable(replaceMap, database, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CreateIndexStatementContext) {
            this.appendFromTable(replaceMap, database, (TableAvailable)sqlStatementContext);
            this.appendFromIndexAndConstraint(replaceMap, database, sqlStatementContext);
        }
        if (sqlStatementContext instanceof AlterTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, database, sqlStatementContext);
            this.appendFromTable(replaceMap, database, (TableAvailable)sqlStatementContext);
        }
        return this.doDecorateActualTable(replaceMap, sql);
    }

    private void appendFromIndexAndConstraint(Map<SQLSegment, String> replaceMap, ShardingSphereDatabase database, SQLStatementContext<?> sqlStatementContext) {
        if (!(sqlStatementContext instanceof TableAvailable) || ((TableAvailable)sqlStatementContext).getTablesContext().getTables().isEmpty()) {
            return;
        }
        TableNameSegment tableNameSegment = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getTables().iterator().next()).getTableName();
        String logicTable = this.findLogicTable(tableNameSegment, database);
        if (!tableNameSegment.getIdentifier().getValue().equals(logicTable)) {
            if (sqlStatementContext instanceof IndexAvailable) {
                for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                    String logicIndexName = IndexMetaDataUtil.getLogicIndexName((String)each.getIndexName().getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each.getIndexName(), logicIndexName);
                }
            }
            if (sqlStatementContext instanceof ConstraintAvailable) {
                for (IndexSegment each : ((ConstraintAvailable)sqlStatementContext).getConstraints()) {
                    String logicConstraint = IndexMetaDataUtil.getLogicIndexName((String)each.getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each, logicConstraint);
                }
            }
        }
    }

    private void appendFromTable(Map<SQLSegment, String> replaceMap, ShardingSphereDatabase database, TableAvailable sqlStatementContext) {
        for (SimpleTableSegment each : sqlStatementContext.getAllTables()) {
            String logicTable = this.findLogicTable(each.getTableName(), database);
            if (logicTable.equals(each.getTableName().getIdentifier().getValue())) continue;
            replaceMap.put((SQLSegment)each.getTableName(), logicTable);
        }
    }

    private String doDecorateActualTable(Map<SQLSegment, String> replaceMap, String sql) {
        StringBuilder result = new StringBuilder();
        int lastStopIndex = 0;
        for (Map.Entry<SQLSegment, String> entry : replaceMap.entrySet()) {
            result.append(sql, lastStopIndex, entry.getKey().getStartIndex());
            result.append(entry.getValue());
            lastStopIndex = entry.getKey().getStopIndex() + 1;
        }
        if (lastStopIndex < sql.length()) {
            result.append(sql, lastStopIndex, sql.length());
        }
        return result.toString();
    }

    private String findLogicTable(TableNameSegment tableNameSegment, ShardingSphereDatabase database) {
        String actualTable = tableNameSegment.getIdentifier().getValue();
        return database.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataNodeContainedRule).map(each -> ((DataNodeContainedRule)each).findLogicTableByActualTable(actualTable).orElse(null)).filter(Objects::nonNull).findFirst().orElse(actualTable);
    }

    private LogicSQL getLogicSQL(String sql, DatabaseType databaseType, String databaseName) {
        Optional sqlParserRule = this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
        Preconditions.checkState((boolean)sqlParserRule.isPresent());
        SQLStatement sqlStatement = ((SQLParserRule)sqlParserRule.get()).getSQLParserEngine(databaseType.getType()).parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.contextManager.getMetaDataContexts().getMetaData().getDatabases(), (SQLStatement)sqlStatement, (String)databaseName);
        return new LogicSQL(sqlStatementContext, sql, Collections.emptyList());
    }

    private Optional<String> decorateOpenGauss(DatabaseType databaseType, String databaseName, String schemaName, String logicSQL) {
        if (logicSQL.toLowerCase().startsWith(SET_SEARCH_PATH_PREFIX)) {
            return Optional.empty();
        }
        return Optional.of(this.replaceTableNameWithPrefix(logicSQL, schemaName + ".", databaseType, databaseName));
    }

    @Generated
    public PipelineDDLGenerator(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

