/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineSimpleLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineSimpleLock.class);
    private static volatile PipelineSimpleLock instance;
    private final LockContext lockContext;
    private final Map<String, Boolean> lockNameLockedMap = new ConcurrentHashMap<String, Boolean>();

    private PipelineSimpleLock() {
        this.lockContext = PipelineContext.getContextManager().getInstanceContext().getLockContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PipelineSimpleLock getInstance() {
        if (null != instance) return instance;
        Class<PipelineSimpleLock> clazz = PipelineSimpleLock.class;
        synchronized (PipelineSimpleLock.class) {
            if (null != instance) return instance;
            instance = new PipelineSimpleLock();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean tryLock(String lockName, long timeoutMills) {
        String realLockName = this.decorateLockName(lockName);
        boolean result = this.lockContext.getLock().tryLock(realLockName, timeoutMills);
        if (result) {
            this.lockNameLockedMap.put(realLockName, true);
        }
        log.info("tryLock, lockName={}, timeoutMills={}, result={}", new Object[]{realLockName, timeoutMills, result});
        return result;
    }

    public void releaseLock(String lockName) {
        String realLockName = this.decorateLockName(lockName);
        log.info("releaseLock, lockName={}", (Object)realLockName);
        if (this.lockNameLockedMap.getOrDefault(realLockName, false).booleanValue()) {
            this.lockNameLockedMap.remove(realLockName);
            this.lockContext.getLock().releaseLock(realLockName);
        }
    }

    private String decorateLockName(String lockName) {
        return "scaling-" + lockName;
    }
}

