/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.yaml.RuleAlteredJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.detect.RuleAlteredJobAlmostCompletedParameter;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.api.pojo.JobInfo;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobWorker;
import org.apache.shardingsphere.data.pipeline.spi.lock.RowBasedJobLock;
import org.apache.shardingsphere.data.pipeline.spi.lock.RuleBasedJobLock;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinishedCheckJob
implements SimpleJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishedCheckJob.class);
    private final RuleAlteredJobAPI ruleAlteredJobAPI = RuleAlteredJobAPIFactory.getInstance();
    private final Set<String> onCheckJobIds = new ConcurrentSkipListSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ShardingContext shardingContext) {
        List jobInfos = this.ruleAlteredJobAPI.list();
        for (JobInfo jobInfo : jobInfos) {
            if (!jobInfo.isActive()) continue;
            String jobId = jobInfo.getJobId();
            if (this.onCheckJobIds.contains(jobId)) {
                log.info("check not completed for job {}, ignore", (Object)jobId);
                continue;
            }
            if (this.isNotAllowDataCheck(jobId)) continue;
            this.onCheckJobIds.add(jobId);
            try {
                RuleAlteredJobConfiguration jobConfig = RuleAlteredJobConfigurationSwapper.swapToObject((String)jobInfo.getJobParameter());
                RuleAlteredContext ruleAlteredContext = RuleAlteredJobWorker.createRuleAlteredContext(jobConfig);
                if (null == ruleAlteredContext.getCompletionDetectAlgorithm()) {
                    log.info("completionDetector not configured, auto switch will not be enabled. You could query job progress and switch config manually with DistSQL.");
                    continue;
                }
                RuleAlteredJobAlmostCompletedParameter parameter = new RuleAlteredJobAlmostCompletedParameter(jobInfo.getShardingTotalCount(), this.ruleAlteredJobAPI.getProgress(jobConfig).values());
                if (!ruleAlteredContext.getCompletionDetectAlgorithm().isAlmostCompleted((Object)parameter)) continue;
                log.info("scaling job {} almost finished.", (Object)jobId);
                RowBasedJobLock rowBasedJobLock = ruleAlteredContext.getRowBasedJobLock();
                String databaseName = jobConfig.getDatabaseName();
                try {
                    if (null != rowBasedJobLock) {
                        rowBasedJobLock.lock(databaseName, jobId + "");
                    }
                    if (!this.ruleAlteredJobAPI.isDataConsistencyCheckNeeded(jobConfig)) {
                        log.info("DataConsistencyCalculatorAlgorithm is not configured, data consistency check is ignored.");
                        this.ruleAlteredJobAPI.switchClusterConfiguration(jobConfig);
                        continue;
                    }
                    if (!this.dataConsistencyCheck(jobConfig)) {
                        log.error("data consistency check failed, job {}", (Object)jobId);
                        continue;
                    }
                    RuleBasedJobLock ruleBasedJobLock = ruleAlteredContext.getRuleBasedJobLock();
                    this.switchClusterConfiguration(databaseName, jobConfig, ruleBasedJobLock);
                }
                finally {
                    if (null == rowBasedJobLock) continue;
                    rowBasedJobLock.releaseLock(databaseName, jobId + "");
                    continue;
                }
                log.info("job {} finished", (Object)jobId);
            }
            catch (Exception ex) {
                log.error("scaling job {} finish check failed!", (Object)jobId, (Object)ex);
            }
            finally {
                this.onCheckJobIds.remove(jobId);
            }
        }
    }

    private boolean isNotAllowDataCheck(String jobId) {
        Map jobProgressMap = this.ruleAlteredJobAPI.getProgress(jobId);
        for (JobProgress each : jobProgressMap.values()) {
            if (null != each && JobStatus.EXECUTE_INCREMENTAL_TASK.equals((Object)each.getStatus())) continue;
            return true;
        }
        return false;
    }

    private boolean dataConsistencyCheck(RuleAlteredJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        log.info("dataConsistencyCheck for job {}", (Object)jobId);
        return this.ruleAlteredJobAPI.aggregateDataConsistencyCheckResults(jobId, this.ruleAlteredJobAPI.dataConsistencyCheck(jobConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchClusterConfiguration(String databaseName, RuleAlteredJobConfiguration jobConfig, RuleBasedJobLock ruleBasedJobLock) {
        String jobId = jobConfig.getJobId();
        try {
            if (null != ruleBasedJobLock) {
                ruleBasedJobLock.lock(databaseName, jobId + "");
            }
            this.ruleAlteredJobAPI.switchClusterConfiguration(jobConfig);
        }
        finally {
            if (null != ruleBasedJobLock) {
                ruleBasedJobLock.releaseLock(databaseName, jobId + "");
            }
        }
    }
}

