/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPositionFactory;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.api.job.JobOperationType;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.ingest.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.spi.ingest.dumper.InventoryDumper;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInventoryDumper
extends AbstractLifecycleExecutor
implements InventoryDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInventoryDumper.class);
    private final InventoryDumperConfiguration dumperConfig;
    private final PipelineChannel channel;
    private final PipelineSQLBuilder pipelineSQLBuilder;
    private final DataSource dataSource;
    private final int batchSize;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;
    private final LazyInitializer<PipelineTableMetaData> tableMetaDataLazyInitializer;

    protected AbstractInventoryDumper(final InventoryDumperConfiguration inventoryDumperConfig, PipelineChannel channel, DataSource dataSource, final PipelineTableMetaDataLoader metaDataLoader) {
        if (!StandardPipelineDataSourceConfiguration.class.equals(inventoryDumperConfig.getDataSourceConfig().getClass())) {
            throw new UnsupportedOperationException("AbstractInventoryDumper only support StandardPipelineDataSourceConfiguration");
        }
        this.dumperConfig = inventoryDumperConfig;
        this.channel = channel;
        this.pipelineSQLBuilder = PipelineSQLBuilderFactory.getInstance(inventoryDumperConfig.getDataSourceConfig().getDatabaseType().getType());
        this.dataSource = dataSource;
        this.batchSize = inventoryDumperConfig.getBatchSize();
        this.rateLimitAlgorithm = inventoryDumperConfig.getRateLimitAlgorithm();
        this.tableMetaDataLazyInitializer = new LazyInitializer<PipelineTableMetaData>(){

            protected PipelineTableMetaData initialize() {
                String schemaName = inventoryDumperConfig.getSchemaName(new LogicTableName(inventoryDumperConfig.getLogicTableName()));
                return metaDataLoader.getTableMetaData(schemaName, inventoryDumperConfig.getActualTableName());
            }
        };
    }

    protected void doStart() {
        this.dump();
    }

    private void dump() {
        String schemaName = this.dumperConfig.getSchemaName(new LogicTableName(this.dumperConfig.getLogicTableName()));
        int uniqueKeyDataType = this.dumperConfig.getUniqueKeyDataType();
        String firstSQL = this.pipelineSQLBuilder.buildInventoryDumpSQL(schemaName, this.dumperConfig.getActualTableName(), this.dumperConfig.getUniqueKey(), uniqueKeyDataType, true);
        String laterSQL = this.pipelineSQLBuilder.buildInventoryDumpSQL(schemaName, this.dumperConfig.getActualTableName(), this.dumperConfig.getUniqueKey(), uniqueKeyDataType, false);
        IngestPosition position = this.dumperConfig.getPosition();
        log.info("inventory dump, uniqueKeyDataType={}, firstSQL={}, laterSQL={}, position={}", new Object[]{uniqueKeyDataType, firstSQL, laterSQL, position});
        if (position instanceof FinishedPosition) {
            log.info("It is already finished, ignore");
            return;
        }
        Object startUniqueKeyValue = this.getPositionBeginValue(position);
        try (Connection conn = this.dataSource.getConnection();){
            Optional<Object> maxUniqueKeyValue;
            int round = 1;
            while ((maxUniqueKeyValue = this.dump0(conn, 1 == round ? firstSQL : laterSQL, uniqueKeyDataType, startUniqueKeyValue, round++)).isPresent()) {
                startUniqueKeyValue = maxUniqueKeyValue.get();
                if (this.isRunning()) continue;
                log.info("inventory dump, running is false, break");
                break;
            }
            log.info("inventory dump done, round={}, maxUniqueKeyValue={}", (Object)round, maxUniqueKeyValue);
        }
        catch (SQLException ex) {
            log.error("inventory dump, ex caught, msg={}", (Object)ex.getMessage());
            throw new IngestException(ex);
        }
        finally {
            log.info("inventory dump, before put FinishedRecord");
            this.pushRecord((Record)new FinishedRecord((IngestPosition)new FinishedPosition()));
        }
    }

    private PipelineTableMetaData getTableMetaData() {
        return (PipelineTableMetaData)this.tableMetaDataLazyInitializer.get();
    }

    private Optional<Object> dump0(Connection conn, String sql, int uniqueKeyDataType, Object startUniqueKeyValue, int round) throws SQLException {
        if (null != this.rateLimitAlgorithm) {
            this.rateLimitAlgorithm.intercept(JobOperationType.SELECT, (Number)1);
        }
        PipelineTableMetaData tableMetaData = this.getTableMetaData();
        try (PreparedStatement preparedStatement = this.createPreparedStatement(conn, sql);){
            Optional<Object> optional;
            block21: {
                preparedStatement.setFetchSize(this.batchSize);
                if (PipelineJdbcUtils.isIntegerColumn(uniqueKeyDataType)) {
                    preparedStatement.setObject(1, startUniqueKeyValue);
                    preparedStatement.setObject(2, this.getPositionEndValue(this.dumperConfig.getPosition()));
                    preparedStatement.setInt(3, this.batchSize);
                } else if (PipelineJdbcUtils.isStringColumn(uniqueKeyDataType)) {
                    preparedStatement.setObject(1, startUniqueKeyValue);
                    preparedStatement.setInt(2, this.batchSize);
                } else {
                    throw new IllegalArgumentException("Unsupported uniqueKeyDataType: " + uniqueKeyDataType);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int rowCount = 0;
                    Object maxUniqueKeyValue = null;
                    String logicTableName = this.dumperConfig.getLogicTableName();
                    while (resultSet.next()) {
                        DataRecord record = new DataRecord(this.newPosition(resultSet), metaData.getColumnCount());
                        record.setType("INSERT");
                        record.setTableName(logicTableName);
                        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                            boolean isUniqueKey = tableMetaData.isUniqueKey(i - 1);
                            Object value = this.readValue(resultSet, i);
                            if (isUniqueKey) {
                                maxUniqueKeyValue = value;
                            }
                            record.addColumn(new Column(metaData.getColumnName(i), value, true, isUniqueKey));
                        }
                        this.pushRecord((Record)record);
                        ++rowCount;
                        if (this.isRunning()) continue;
                        log.info("dump, running is false, break");
                        break;
                    }
                    if (0 == round % 50) {
                        log.info("dump, round={}, rowCount={}, maxUniqueKeyValue={}", new Object[]{round, rowCount, maxUniqueKeyValue});
                    }
                    optional = Optional.ofNullable(maxUniqueKeyValue);
                    if (resultSet == null) break block21;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return optional;
        }
    }

    private Object getPositionBeginValue(IngestPosition<?> position) {
        return ((PrimaryKeyPosition)position).getBeginValue();
    }

    private Object getPositionEndValue(IngestPosition<?> position) {
        return ((PrimaryKeyPosition)position).getEndValue();
    }

    private IngestPosition<?> newPosition(ResultSet rs) throws SQLException {
        return null == this.dumperConfig.getUniqueKey() ? new PlaceholderPosition() : PrimaryKeyPositionFactory.newInstance((Object)rs.getObject(this.dumperConfig.getUniqueKey()), (Object)((PrimaryKeyPosition)this.dumperConfig.getPosition()).getEndValue());
    }

    protected abstract PreparedStatement createPreparedStatement(Connection var1, String var2) throws SQLException;

    protected Object readValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getObject(index);
    }

    private void pushRecord(Record record) {
        this.channel.pushRecord(record);
    }

    protected void doStop() {
    }

    @Generated
    protected InventoryDumperConfiguration getDumperConfig() {
        return this.dumperConfig;
    }
}

