/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.RuleAlteredJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.yaml.RuleAlteredJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.lock.PipelineSimpleLock;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJob;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobCenter;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobPreparer;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobProgressDetector;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobSchedulerCenter;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingReleaseDatabaseLevelLockEvent;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobExecutor
extends AbstractLifecycleExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobExecutor.class);
    private static final Pattern CONFIG_PATTERN = Pattern.compile("/scaling/(\\d{2}[0-9a-f]+)/config");
    private final ExecutorService executor = Executors.newFixedThreadPool(20);

    protected void doStart() {
        PipelineAPIFactory.getGovernanceRepositoryAPI().watch("/scaling", event -> this.getJobConfigPOJO(event).ifPresent(optional -> this.processEvent(event, (JobConfigurationPOJO)optional)));
    }

    private Optional<JobConfigurationPOJO> getJobConfigPOJO(DataChangedEvent event) {
        try {
            if (CONFIG_PATTERN.matcher(event.getKey()).matches()) {
                log.info("{} job config: {}", (Object)event.getType(), (Object)event.getKey());
                return Optional.of((JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class, (boolean)true));
            }
        }
        catch (Exception ex) {
            log.error("analyze job config pojo failed.", (Throwable)ex);
        }
        return Optional.empty();
    }

    private void processEvent(DataChangedEvent event, JobConfigurationPOJO jobConfigPOJO) {
        boolean isDeleted = DataChangedEvent.Type.DELETED == event.getType();
        boolean isDisabled = jobConfigPOJO.isDisabled();
        if (isDeleted || isDisabled) {
            log.info("jobId={}, deleted={}, disabled={}", new Object[]{jobConfigPOJO.getJobName(), isDeleted, isDisabled});
            RuleAlteredJobCenter.stop(jobConfigPOJO.getJobName());
            RuleAlteredJobConfiguration jobConfig = RuleAlteredJobConfigurationSwapper.swapToObject((String)jobConfigPOJO.getJobParameter());
            if (isDeleted) {
                new RuleAlteredJobPreparer().cleanup(jobConfig);
            } else if (RuleAlteredJobProgressDetector.isJobSuccessful(jobConfig.getJobShardingCount(), RuleAlteredJobAPIFactory.getInstance().getProgress(jobConfig).values())) {
                log.info("isJobSuccessful=true");
                new RuleAlteredJobPreparer().cleanup(jobConfig);
            }
            ShardingSphereEventBus.getInstance().post((Object)new ScalingReleaseDatabaseLevelLockEvent(jobConfig.getDatabaseName()));
            return;
        }
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                if (RuleAlteredJobSchedulerCenter.existJob(jobConfigPOJO.getJobName())) {
                    log.info("{} added to executing jobs failed since it already exists", (Object)jobConfigPOJO.getJobName());
                    break;
                }
                this.executor.execute(() -> this.execute(jobConfigPOJO));
                break;
            }
        }
    }

    private void execute(JobConfigurationPOJO jobConfigPOJO) {
        String databaseName = RuleAlteredJobConfigurationSwapper.swapToObject((String)jobConfigPOJO.getJobParameter()).getDatabaseName();
        if (PipelineSimpleLock.getInstance().tryLock(databaseName, 3000L)) {
            log.info("{} added to executing jobs success", (Object)jobConfigPOJO.getJobName());
            RuleAlteredJob job = new RuleAlteredJob();
            RuleAlteredJobCenter.addJob(jobConfigPOJO.getJobName(), job);
            new OneOffJobBootstrap(PipelineAPIFactory.getRegistryCenter(), (ElasticJob)job, jobConfigPOJO.toJobConfiguration()).execute();
        } else {
            log.info("tryLock failed, databaseName={}", (Object)databaseName);
        }
    }

    protected void doStop() {
        this.executor.shutdown();
        this.executor.shutdownNow();
    }
}

