/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceChecker
implements DataSourceChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceChecker.class);

    public final void checkConnection(Collection<? extends DataSource> dataSources) {
        try {
            for (DataSource dataSource : dataSources) {
                dataSource.getConnection().close();
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Data sources can not connect.", ex);
        }
    }

    public final void checkTargetTable(Collection<? extends DataSource> dataSources, TableNameSchemaNameMapping tableNameSchemaNameMapping, Collection<String> logicTableNames) {
        try {
            for (DataSource dataSource : dataSources) {
                this.checkEmpty(dataSource, tableNameSchemaNameMapping, logicTableNames);
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("Check target table failed.", ex);
        }
    }

    private void checkEmpty(DataSource dataSource, TableNameSchemaNameMapping tableNameSchemaNameMapping, Collection<String> logicTableNames) throws SQLException {
        for (String each : logicTableNames) {
            String sql = this.getSQLBuilder().buildCheckEmptySQL(tableNameSchemaNameMapping.getSchemaName(each), each);
            log.info("checkEmpty, sql={}", (Object)sql);
            Connection connection = dataSource.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    ResultSet resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) continue;
                        throw new PipelineJobPrepareFailedException(String.format("Target table `%s` is not empty, sql: %s.", each, sql));
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    private PipelineSQLBuilder getSQLBuilder() {
        return PipelineSQLBuilderFactory.getInstance(this.getDatabaseType());
    }

    protected abstract String getDatabaseType();

    public String getType() {
        return this.getDatabaseType();
    }
}

