/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm.AbstractStreamingDataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineDataConsistencyCheckFailedException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.spi.type.typed.TypedSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataMatchDataConsistencyCalculateAlgorithm
extends AbstractStreamingDataConsistencyCalculateAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataMatchDataConsistencyCalculateAlgorithm.class);
    private static final Collection<String> SUPPORTED_DATABASE_TYPES = DatabaseTypeFactory.getInstances().stream().map(TypedSPI::getType).collect(Collectors.toList());
    private static final String CHUNK_SIZE_KEY = "chunk-size";
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private Properties props;
    private int chunkSize;
    private final Map<String, String> firstSQLCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> laterSQLCache = new ConcurrentHashMap<String, String>();

    public void init(Properties props) {
        this.props = props;
        this.chunkSize = this.getChunkSize(props);
    }

    private int getChunkSize(Properties props) {
        int result = Integer.parseInt(props.getProperty(CHUNK_SIZE_KEY, "1000"));
        if (result <= 0) {
            log.warn("Invalid result={}, use default value", (Object)result);
            return 1000;
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<Object> calculateChunk(DataConsistencyCalculateParameter parameter) {
        CalculatedResult previousCalculatedResult = (CalculatedResult)parameter.getPreviousCalculatedResult();
        String sql = this.getQuerySQL(parameter);
        try (Connection connection = parameter.getDataSource().getConnection();){
            Optional<Object> optional;
            block25: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    if (null == previousCalculatedResult) {
                        preparedStatement.setInt(1, this.chunkSize);
                    } else {
                        preparedStatement.setObject(1, previousCalculatedResult.getMaxUniqueKeyValue());
                        preparedStatement.setInt(2, this.chunkSize);
                    }
                    LinkedList<Collection<Object>> records = new LinkedList<Collection<Object>>();
                    Object maxUniqueKeyValue = null;
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            int columnCount = resultSetMetaData.getColumnCount();
                            LinkedList<Object> record = new LinkedList<Object>();
                            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                                record.add(resultSet.getObject(columnIndex));
                            }
                            records.add(record);
                            maxUniqueKeyValue = resultSet.getObject(parameter.getUniqueKey());
                        }
                    }
                    Optional<Object> optional2 = optional = records.isEmpty() ? Optional.empty() : Optional.of(new CalculatedResult(maxUniqueKeyValue, records.size(), records));
                    if (preparedStatement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new PipelineDataConsistencyCheckFailedException(String.format("table %s data check failed.", parameter.getLogicTableName()), ex);
        }
    }

    private String getQuerySQL(DataConsistencyCalculateParameter parameter) {
        PipelineSQLBuilder sqlBuilder = PipelineSQLBuilderFactory.getInstance(parameter.getDatabaseType());
        String logicTableName = parameter.getLogicTableName();
        String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(logicTableName);
        String uniqueKey = parameter.getUniqueKey();
        String cacheKey = schemaName.toLowerCase() + "." + logicTableName.toLowerCase();
        if (null == parameter.getPreviousCalculatedResult()) {
            return this.firstSQLCache.computeIfAbsent(cacheKey, s -> sqlBuilder.buildChunkedQuerySQL(schemaName, logicTableName, uniqueKey, true));
        }
        return this.laterSQLCache.computeIfAbsent(cacheKey, s -> sqlBuilder.buildChunkedQuerySQL(schemaName, logicTableName, uniqueKey, false));
    }

    public String getType() {
        return "DATA_MATCH";
    }

    public Collection<String> getSupportedDatabaseTypes() {
        return SUPPORTED_DATABASE_TYPES;
    }

    public String getDescription() {
        return "Match raw data of records.";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    private static final class CalculatedResult {
        @NonNull
        private final Object maxUniqueKeyValue;
        private final int recordCount;
        private final Collection<Collection<Object>> records;

        public boolean equals(@NonNull Object o) {
            if (o == null) {
                throw new NullPointerException("o is marked non-null but is null");
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof CalculatedResult)) {
                log.warn("CalculatedResult type not match, o.className={}", (Object)o.getClass().getName());
                return false;
            }
            CalculatedResult that = (CalculatedResult)o;
            boolean equalsFirst = new EqualsBuilder().append(this.getRecordCount(), that.getRecordCount()).append(this.getMaxUniqueKeyValue(), that.getMaxUniqueKeyValue()).isEquals();
            if (!equalsFirst) {
                log.warn("recordCount or maxUniqueKeyValue not match, recordCount1={}, recordCount2={}, maxUniqueKeyValue1={}, maxUniqueKeyValue2={}", new Object[]{this.getRecordCount(), that.getRecordCount(), this.getMaxUniqueKeyValue(), that.getMaxUniqueKeyValue()});
                return false;
            }
            Iterator<Collection<Object>> thisIterator = this.records.iterator();
            Iterator<Collection<Object>> thatIterator = that.records.iterator();
            while (thisIterator.hasNext() && thatIterator.hasNext()) {
                Collection<Object> thisNext = thisIterator.next();
                Collection<Object> thatNext = thatIterator.next();
                if (thisNext.size() != thatNext.size()) {
                    log.warn("record column size not match, size1={}, size2={}, record1={}, record2={}", new Object[]{thisNext.size(), thatNext.size(), thisNext, thatNext});
                    return false;
                }
                Iterator<Object> thisNextIterator = thisNext.iterator();
                Iterator<Object> thatNextIterator = thatNext.iterator();
                while (thisNextIterator.hasNext() && thatNextIterator.hasNext()) {
                    Object thisResult = thisNextIterator.next();
                    Object thatResult = thatNextIterator.next();
                    if (thisResult instanceof SQLXML && thatResult instanceof SQLXML) {
                        return ((SQLXML)thisResult).getString().equals(((SQLXML)thatResult).getString());
                    }
                    if (new EqualsBuilder().append(thisResult, thatResult).isEquals()) continue;
                    log.warn("record column value not match, value1={}, value2={}, record1={}, record2={}", new Object[]{thisResult, thatResult, thisNext, thatNext});
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.getMaxUniqueKeyValue()).append(this.getRecordCount()).append(this.getRecords()).toHashCode();
        }

        @Generated
        public CalculatedResult(@NonNull Object maxUniqueKeyValue, int recordCount, Collection<Collection<Object>> records) {
            if (maxUniqueKeyValue == null) {
                throw new NullPointerException("maxUniqueKeyValue is marked non-null but is null");
            }
            this.maxUniqueKeyValue = maxUniqueKeyValue;
            this.recordCount = recordCount;
            this.records = records;
        }

        @NonNull
        @Generated
        public Object getMaxUniqueKeyValue() {
            return this.maxUniqueKeyValue;
        }

        @Generated
        public int getRecordCount() {
            return this.recordCount;
        }

        @Generated
        public Collection<Collection<Object>> getRecords() {
            return this.records;
        }
    }
}

