/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculateParameter;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamingDataConsistencyCalculateAlgorithm
implements DataConsistencyCalculateAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamingDataConsistencyCalculateAlgorithm.class);

    public final Iterable<Object> calculate(DataConsistencyCalculateParameter parameter) {
        return new ResultIterable(parameter);
    }

    protected abstract Optional<Object> calculateChunk(DataConsistencyCalculateParameter var1);

    @Generated
    public AbstractStreamingDataConsistencyCalculateAlgorithm() {
    }

    final class ResultIterable
    implements Iterable<Object> {
        private final DataConsistencyCalculateParameter parameter;

        @Override
        public Iterator<Object> iterator() {
            return new ResultIterator(this.parameter);
        }

        @Generated
        public ResultIterable(DataConsistencyCalculateParameter parameter) {
            this.parameter = parameter;
        }
    }

    final class ResultIterator
    implements Iterator<Object> {
        private final DataConsistencyCalculateParameter parameter;
        private final AtomicInteger calculationCount = new AtomicInteger(0);
        private volatile Optional<Object> nextResult;

        @Override
        public boolean hasNext() {
            this.calculateIfNecessary();
            return this.nextResult.isPresent();
        }

        @Override
        public Object next() {
            this.calculateIfNecessary();
            Optional<Object> nextResult = this.nextResult;
            this.parameter.setPreviousCalculatedResult(nextResult.orElse(null));
            this.nextResult = null;
            return nextResult.orElse(null);
        }

        private void calculateIfNecessary() {
            if (null != this.nextResult) {
                return;
            }
            this.nextResult = AbstractStreamingDataConsistencyCalculateAlgorithm.this.calculateChunk(this.parameter);
            if (!this.nextResult.isPresent()) {
                log.info("nextResult not present, calculation done. calculationCount={}", (Object)this.calculationCount);
            }
            if (this.calculationCount.incrementAndGet() % 1000000 == 0) {
                log.warn("possible infinite loop, calculationCount={}", (Object)this.calculationCount);
            }
        }

        @Generated
        public ResultIterator(DataConsistencyCalculateParameter parameter) {
            this.parameter = parameter;
        }
    }
}

