/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.api.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.api.task.progress.InventoryTaskProgress;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.JobProgressYamlSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlJobProgress;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GovernanceRepositoryAPIImpl
implements GovernanceRepositoryAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GovernanceRepositoryAPIImpl.class);
    private static final JobProgressYamlSwapper JOB_PROGRESS_YAML_SWAPPER = new JobProgressYamlSwapper();
    private final ClusterPersistRepository repository;

    @Override
    public boolean isExisted(String key) {
        return null != this.repository.get(key);
    }

    @Override
    public void persistJobProgress(RuleAlteredJobContext jobContext) {
        JobProgress jobProgress = new JobProgress();
        jobProgress.setStatus(jobContext.getStatus());
        jobProgress.setSourceDatabaseType(jobContext.getJobConfig().getSourceDatabaseType());
        jobProgress.setIncrementalTaskProgressMap(this.getIncrementalTaskProgressMap(jobContext));
        jobProgress.setInventoryTaskProgressMap(this.getInventoryTaskProgressMap(jobContext));
        String value = YamlEngine.marshal((Object)JOB_PROGRESS_YAML_SWAPPER.swapToYaml(jobProgress));
        this.repository.persist(PipelineMetaDataNode.getScalingJobOffsetPath(jobContext.getJobId(), jobContext.getShardingItem()), value);
    }

    private Map<String, IncrementalTaskProgress> getIncrementalTaskProgressMap(RuleAlteredJobContext jobContext) {
        HashMap<String, IncrementalTaskProgress> result = new HashMap<String, IncrementalTaskProgress>(jobContext.getIncrementalTasks().size(), 1.0f);
        for (IncrementalTask each : jobContext.getIncrementalTasks()) {
            result.put(each.getTaskId(), each.getProgress());
        }
        return result;
    }

    private Map<String, InventoryTaskProgress> getInventoryTaskProgressMap(RuleAlteredJobContext jobContext) {
        HashMap<String, InventoryTaskProgress> result = new HashMap<String, InventoryTaskProgress>(jobContext.getInventoryTasks().size(), 1.0f);
        for (InventoryTask each : jobContext.getInventoryTasks()) {
            result.put(each.getTaskId(), each.getProgress());
        }
        return result;
    }

    @Override
    public JobProgress getJobProgress(String jobId, int shardingItem) {
        String data = this.repository.get(PipelineMetaDataNode.getScalingJobOffsetPath(jobId, shardingItem));
        if (Strings.isNullOrEmpty((String)data)) {
            return null;
        }
        return JOB_PROGRESS_YAML_SWAPPER.swapToObject((YamlJobProgress)YamlEngine.unmarshal((String)data, YamlJobProgress.class));
    }

    @Override
    public void persistJobCheckResult(String jobId, boolean checkSuccess) {
        log.info("persist job check result '{}' for job {}", (Object)checkSuccess, (Object)jobId);
        this.repository.persist(PipelineMetaDataNode.getScalingCheckResultPath(jobId), String.valueOf(checkSuccess));
    }

    @Override
    public Optional<Boolean> getJobCheckResult(String jobId) {
        String data = this.repository.get(PipelineMetaDataNode.getScalingCheckResultPath(jobId));
        return Strings.isNullOrEmpty((String)data) ? Optional.empty() : Optional.of(Boolean.parseBoolean(data));
    }

    @Override
    public void deleteJob(String jobId) {
        log.info("delete job {}", (Object)jobId);
        this.repository.delete(PipelineMetaDataNode.getScalingJobPath(jobId));
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        return this.repository.getChildrenKeys(key);
    }

    @Override
    public void watch(String key, DataChangedEventListener listener) {
        this.repository.watch(key, listener);
    }

    @Override
    public void persist(String key, String value) {
        this.repository.persist(key, value);
    }

    @Override
    public List<Integer> getShardingItems(String jobId) {
        List<String> result = this.getChildrenKeys(PipelineMetaDataNode.getScalingJobOffsetPath(jobId));
        log.info("getShardingItems, jobId={}, offsetKeys={}", (Object)jobId, result);
        return result.stream().map(Integer::parseInt).collect(Collectors.toList());
    }

    @Override
    public void updateShardingJobStatus(String jobId, int shardingItem, JobStatus status) {
        JobProgress jobProgress = this.getJobProgress(jobId, shardingItem);
        if (null == jobProgress) {
            log.warn("updateShardingJobStatus, jobProgress is null, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
            return;
        }
        jobProgress.setStatus(status);
        this.persist(PipelineMetaDataNode.getScalingJobOffsetPath(jobId, shardingItem), YamlEngine.marshal((Object)JOB_PROGRESS_YAML_SWAPPER.swapToYaml(jobProgress)));
    }

    @Generated
    public GovernanceRepositoryAPIImpl(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

