/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineVerifyFailedException;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineJobAPIImpl
implements PipelineJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineJobAPIImpl.class);
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void startDisabledJob(String jobId) {
        log.info("Start disabled pipeline job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        if (!jobConfigPOJO.isDisabled()) {
            throw new PipelineVerifyFailedException("Job is already started.");
        }
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().remove("stop_time");
        PipelineAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
    }

    public void stop(String jobId) {
        log.info("Stop pipeline job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        PipelineAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
    }

    public void remove(String jobId) {
        log.info("Remove pipeline job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        this.verifyJobStopped(jobConfigPOJO);
        PipelineAPIFactory.getJobOperateAPI().remove(String.valueOf(jobId), null);
        PipelineAPIFactory.getGovernanceRepositoryAPI().deleteJob(jobId);
    }

    protected final JobConfigurationPOJO getElasticJobConfigPOJO(String jobId) {
        JobConfigurationPOJO result = PipelineAPIFactory.getJobConfigurationAPI().getJobConfiguration(jobId);
        if (null == result) {
            throw new PipelineJobNotFoundException(String.format("Can not find scaling job %s", jobId), jobId);
        }
        return result;
    }

    protected final void verifyJobNotStopped(JobConfigurationPOJO jobConfigPOJO) {
        if (jobConfigPOJO.isDisabled()) {
            throw new PipelineVerifyFailedException("Job is stopped, it's not necessary to do it.");
        }
    }

    protected final void verifyJobStopped(JobConfigurationPOJO jobConfigPOJO) {
        if (!jobConfigPOJO.isDisabled()) {
            throw new PipelineVerifyFailedException("Job is not stopped. You could run `STOP SCALING {jobId}` to stop it.");
        }
    }
}

