/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.generator;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.node.WorkerIdNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ClusterWorkerIdGenerator
implements WorkerIdGenerator {
    private final ClusterPersistRepository repository;
    private final RegistryCenter registryCenter;
    private final InstanceDefinition instanceDefinition;

    public long generate() {
        return this.registryCenter.getComputeNodeStatusService().loadInstanceWorkerId(this.instanceDefinition.getInstanceId()).orElseGet(this::reGenerate);
    }

    private Long reGenerate() {
        Long result = Long.valueOf(Optional.ofNullable(this.repository.getSequentialId(WorkerIdNode.getWorkerIdGeneratorPath(this.instanceDefinition.getInstanceId()), "")).orElse("0"));
        this.registryCenter.getComputeNodeStatusService().persistInstanceWorkerId(this.instanceDefinition.getInstanceId(), result);
        return result;
    }

    @Generated
    public ClusterWorkerIdGenerator(ClusterPersistRepository repository, RegistryCenter registryCenter, InstanceDefinition instanceDefinition) {
        this.repository = repository;
        this.registryCenter = registryCenter;
        this.instanceDefinition = instanceDefinition;
    }
}

