/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.watcher;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.PrimaryStateChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node.StorageStatusNode;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeRole;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class StorageNodeStateChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singletonList(StorageStatusNode.getRootPath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        Optional<QualifiedDatabase> qualifiedSchema = StorageStatusNode.extractQualifiedSchema(event.getKey());
        if (qualifiedSchema.isPresent()) {
            QualifiedDatabase schema = qualifiedSchema.get();
            StorageNodeDataSource storageNodeDataSource = (StorageNodeDataSource)YamlEngine.unmarshal((String)event.getValue(), StorageNodeDataSource.class);
            if (StorageNodeRole.PRIMARY.name().toLowerCase().equals(storageNodeDataSource.getRole())) {
                return Optional.of(new PrimaryStateChangedEvent(schema));
            }
            return Optional.of(new DisabledStateChangedEvent(schema, DataChangedEvent.Type.DELETED == event.getType() || StorageNodeStatus.DISABLED.name().toLowerCase().equals(storageNodeDataSource.getStatus())));
        }
        return Optional.empty();
    }
}

