/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.watcher;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListTriggerEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListUnitCompleteEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.StateEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.WorkerIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdDeletedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class ComputeNodeStateChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(ComputeNode.getComputeNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        String instanceId = ComputeNode.getInstanceIdByComputeNode((String)event.getKey());
        if (!Strings.isNullOrEmpty((String)instanceId)) {
            if (event.getKey().equals(ComputeNode.getInstanceStatusNodePath((String)instanceId))) {
                ArrayList<String> status = Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList<String>() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class);
                return Optional.of(new StateEvent(instanceId, status));
            }
            if (event.getKey().equals(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId))) {
                return Optional.of(new WorkerIdEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? null : Long.valueOf(event.getValue())));
            }
            if (event.getKey().equals(ComputeNode.getInstanceLabelsNodePath((String)instanceId))) {
                return Optional.of(new LabelsEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList<String>() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class)));
            }
        } else {
            if (event.getKey().startsWith(ComputeNode.getOnlineInstanceNodePath())) {
                Optional instanceDefinition = ComputeNode.getInstanceDefinitionByInstanceOnlinePath((String)event.getKey());
                return instanceDefinition.isPresent() ? this.createInstanceEvent((InstanceDefinition)instanceDefinition.get(), event.getType(), event.getValue()) : Optional.empty();
            }
            if (event.getKey().startsWith(ComputeNode.getProcessTriggerNodePatch())) {
                return this.createShowProcessListTriggerEvent(event);
            }
            if (event.getKey().startsWith(ComputeNode.getXaRecoveryIdNodePath())) {
                return this.createXaRecoveryIdEvent(event);
            }
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createShowProcessListTriggerEvent(DataChangedEvent event) {
        Matcher matcher = ComputeNodeStateChangedWatcher.getShowProcessTriggerMatcher(event);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            return Optional.of(new ShowProcessListTriggerEvent(matcher.group(1), matcher.group(2)));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new ShowProcessListUnitCompleteEvent(matcher.group(2)));
        }
        return Optional.empty();
    }

    private static Matcher getShowProcessTriggerMatcher(DataChangedEvent event) {
        Pattern pattern = Pattern.compile(ComputeNode.getProcessTriggerNodePatch() + "/([\\S]+):([\\S]+)$", 2);
        return pattern.matcher(event.getKey());
    }

    private Optional<GovernanceEvent> createInstanceEvent(InstanceDefinition instanceDefinition, DataChangedEvent.Type type, String value) {
        if (DataChangedEvent.Type.ADDED == type) {
            instanceDefinition.setAttributes(value);
            return Optional.of(new InstanceOnlineEvent(instanceDefinition));
        }
        if (DataChangedEvent.Type.DELETED == type) {
            return Optional.of(new InstanceOfflineEvent(instanceDefinition));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createXaRecoveryIdEvent(DataChangedEvent event) {
        Matcher matcher = Pattern.compile(ComputeNode.getXaRecoveryIdNodePath() + "/([\\S]+)/([\\S]+)$", 2).matcher(event.getKey());
        if (matcher.find()) {
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                return Optional.of(new XaRecoveryIdAddedEvent(matcher.group(2), matcher.group(1)));
            }
            if (DataChangedEvent.Type.DELETED == event.getType()) {
                return Optional.of(new XaRecoveryIdDeletedEvent(matcher.group(2), matcher.group(1)));
            }
        }
        return Optional.empty();
    }
}

