/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.subscriber;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ComputeNodeStatusChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ComputeNodeStatusSubscriber {
    private final RegistryCenter registryCenter;
    private final ClusterPersistRepository repository;

    public ComputeNodeStatusSubscriber(RegistryCenter registryCenter, ClusterPersistRepository repository) {
        this.registryCenter = registryCenter;
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(ComputeNodeStatusChangedEvent event) {
        Collection<String> status;
        String computeStatusNodePath = ComputeNode.getInstanceStatusNodePath((String)event.getInstanceId());
        String yamlContext = this.repository.get(computeStatusNodePath);
        Collection collection = status = Strings.isNullOrEmpty((String)yamlContext) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContext, Collection.class);
        if (event.getStatus() == ComputeNodeStatus.CIRCUIT_BREAK) {
            status.add(ComputeNodeStatus.CIRCUIT_BREAK.name());
        } else {
            status.remove(ComputeNodeStatus.CIRCUIT_BREAK.name());
        }
        this.repository.persistEphemeral(computeStatusNodePath, YamlEngine.marshal(status));
    }

    @Subscribe
    public void update(XaRecoveryIdChangedEvent event) {
        this.registryCenter.getComputeNodeStatusService().persistInstanceXaRecoveryId(event.getInstanceId(), event.getXaRecoveryIds());
    }

    @Subscribe
    public void update(LabelsChangedEvent event) {
        if (event.getLabels().isEmpty()) {
            this.registryCenter.getComputeNodeStatusService().persistInstanceLabels(event.getInstanceId(), Collections.EMPTY_LIST);
        } else {
            this.registryCenter.getComputeNodeStatusService().persistInstanceLabels(event.getInstanceId(), event.getLabels());
        }
    }
}

