/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.service;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeNodeStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeStatusService.class);
    private final ClusterPersistRepository repository;

    public void registerOnline(InstanceDefinition instanceDefinition) {
        this.repository.persistEphemeral(ComputeNode.getOnlineInstanceNodePath((String)instanceDefinition.getInstanceId(), (InstanceType)instanceDefinition.getInstanceType()), instanceDefinition.getAttributes());
    }

    public void persistInstanceLabels(String instanceId, Collection<String> labels) {
        if (null != labels) {
            this.repository.persistEphemeral(ComputeNode.getInstanceLabelsNodePath((String)instanceId), YamlEngine.marshal(labels));
        }
    }

    public void persistInstanceWorkerId(String instanceId, Long workerId) {
        this.repository.persistEphemeral(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId), String.valueOf(workerId));
    }

    public void persistInstanceXaRecoveryId(String instanceId, Collection<String> xaRecoveryIds) {
        Collection<String> originalXaRecoveryIds = this.loadXaRecoveryIds(instanceId);
        if (originalXaRecoveryIds.isEmpty()) {
            xaRecoveryIds.forEach(each -> this.repository.persistEphemeral(ComputeNode.getInstanceXaRecoveryIdNodePath((String)each, (String)instanceId), ""));
        } else {
            originalXaRecoveryIds.stream().filter(each -> !xaRecoveryIds.contains(each)).forEach(each -> this.repository.delete(ComputeNode.getInstanceXaRecoveryIdNodePath((String)each, (String)instanceId)));
            xaRecoveryIds.stream().filter(each -> !originalXaRecoveryIds.contains(each)).forEach(each -> this.repository.persistEphemeral(ComputeNode.getInstanceXaRecoveryIdNodePath((String)each, (String)instanceId), ""));
        }
    }

    public Collection<String> loadInstanceLabels(String instanceId) {
        String yamlContent = this.repository.get(ComputeNode.getInstanceLabelsNodePath((String)instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public Collection<String> loadInstanceStatus(String instanceId) {
        String yamlContent = this.repository.get(ComputeNode.getInstanceStatusNodePath((String)instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public Optional<Long> loadInstanceWorkerId(String instanceId) {
        try {
            String workerId = this.repository.get(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId));
            return Strings.isNullOrEmpty((String)workerId) ? Optional.empty() : Optional.of(Long.valueOf(workerId));
        }
        catch (NumberFormatException ex) {
            log.error("Invalid worker id for instance: {}", (Object)instanceId);
            return Optional.empty();
        }
    }

    public Collection<String> loadXaRecoveryIds(String instanceId) {
        LinkedList<String> result = new LinkedList<String>();
        List xaRecoveryIds = this.repository.getChildrenKeys(ComputeNode.getXaRecoveryIdNodePath());
        for (String xaRecoveryId : xaRecoveryIds) {
            if (!this.repository.getChildrenKeys(String.join((CharSequence)"/", ComputeNode.getXaRecoveryIdNodePath(), xaRecoveryId)).contains(instanceId)) continue;
            result.add(xaRecoveryId);
        }
        return result;
    }

    public Collection<ComputeNodeInstance> loadAllComputeNodeInstances() {
        ArrayList<ComputeNodeInstance> result = new ArrayList<ComputeNodeInstance>();
        Arrays.stream(InstanceType.values()).forEach(instanceType -> {
            List onlineComputeNodes = this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)instanceType));
            onlineComputeNodes.forEach(each -> {
                InstanceDefinition instanceDefinition = new InstanceDefinition(instanceType, each);
                instanceDefinition.setAttributes(this.repository.get(ComputeNode.getOnlineInstanceNodePath((String)each, (InstanceType)instanceType)));
                result.add(this.loadComputeNodeInstance(instanceDefinition));
            });
        });
        return result;
    }

    public ComputeNodeInstance loadComputeNodeInstance(InstanceDefinition instanceDefinition) {
        ComputeNodeInstance result = new ComputeNodeInstance(instanceDefinition);
        result.setLabels(this.loadInstanceLabels(instanceDefinition.getInstanceId()));
        result.switchState(this.loadInstanceStatus(instanceDefinition.getInstanceId()));
        result.getXaRecoveryIds().addAll(this.loadXaRecoveryIds(instanceDefinition.getInstanceId()));
        this.loadInstanceWorkerId(instanceDefinition.getInstanceId()).ifPresent(arg_0 -> ((ComputeNodeInstance)result).setWorkerId(arg_0));
        return result;
    }

    @Generated
    public ComputeNodeStatusService(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

