/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.subscriber;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessUnit;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.ShowProcessListManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ExecuteProcessReportEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ExecuteProcessSummaryReportEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ExecuteProcessUnitReportEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ShowProcessListRequestEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ShowProcessListResponseEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.lock.ShowProcessListSimpleLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.node.ProcessNode;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ProcessRegistrySubscriber {
    private final ClusterPersistRepository repository;

    public ProcessRegistrySubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void loadShowProcessListData(ShowProcessListRequestEvent event) {
        String showProcessListId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString();
        boolean triggerIsComplete = false;
        Collection<String> triggerPaths = this.getTriggerPaths(showProcessListId);
        try {
            triggerPaths.forEach(each -> this.repository.persist(each, ""));
            triggerIsComplete = this.waitUntilShowProcessIsReady(showProcessListId, triggerPaths);
            this.sendShowProcessList(showProcessListId);
        }
        finally {
            this.repository.delete(ProcessNode.getShowProcessListIdPath(showProcessListId));
            if (!triggerIsComplete) {
                triggerPaths.forEach(arg_0 -> ((ClusterPersistRepository)this.repository).delete(arg_0));
            }
        }
    }

    private Collection<String> getTriggerPaths(String showProcessListId) {
        return Arrays.stream(InstanceType.values()).flatMap(each -> this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)each)).stream().map(onlinePath -> ComputeNode.getProcessTriggerInstanceIdNodePath((String)onlinePath, (String)showProcessListId))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilShowProcessIsReady(String showProcessListId, Collection<String> triggerPaths) {
        ShowProcessListSimpleLock simpleLock = new ShowProcessListSimpleLock();
        ShowProcessListManager.getInstance().getLocks().put(showProcessListId, simpleLock);
        simpleLock.lock();
        try {
            while (!this.isReady(triggerPaths)) {
                if (simpleLock.awaitDefaultTime()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            simpleLock.unlock();
            ShowProcessListManager.getInstance().getLocks().remove(showProcessListId);
        }
    }

    private boolean isReady(Collection<String> triggerPaths) {
        return triggerPaths.stream().noneMatch(each -> null != this.repository.get(each));
    }

    private void sendShowProcessList(String showProcessListId) {
        List childrenKeys = this.repository.getChildrenKeys(ProcessNode.getShowProcessListIdPath(showProcessListId));
        LinkedList<String> batchProcessContexts = new LinkedList<String>();
        for (String each : childrenKeys) {
            batchProcessContexts.add(this.repository.get(ProcessNode.getShowProcessListInstancePath(showProcessListId, each)));
        }
        ShardingSphereEventBus.getInstance().post((Object)new ShowProcessListResponseEvent(batchProcessContexts));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void reportExecuteProcessSummary(ExecuteProcessSummaryReportEvent event) {
        ExecuteProcessContext executeProcessContext = event.getExecuteProcessContext();
        ShowProcessListManager.getInstance().putProcessContext(executeProcessContext.getExecutionID(), new YamlExecuteProcessContext(executeProcessContext));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void reportExecuteProcessUnit(ExecuteProcessUnitReportEvent event) {
        String executionID = event.getExecutionID();
        YamlExecuteProcessContext yamlExecuteProcessContext = ShowProcessListManager.getInstance().getProcessContext(executionID);
        ExecuteProcessUnit executeProcessUnit = event.getExecuteProcessUnit();
        for (YamlExecuteProcessUnit each : yamlExecuteProcessContext.getUnitStatuses()) {
            if (!each.getUnitID().equals(executeProcessUnit.getUnitID())) continue;
            each.setStatus(executeProcessUnit.getStatus());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void reportExecuteProcess(ExecuteProcessReportEvent event) {
        YamlExecuteProcessContext yamlExecuteProcessContext = ShowProcessListManager.getInstance().getProcessContext(event.getExecutionID());
        for (YamlExecuteProcessUnit each : yamlExecuteProcessContext.getUnitStatuses()) {
            if (each.getStatus() == ExecuteProcessConstants.EXECUTE_STATUS_DONE) continue;
            return;
        }
        ShowProcessListManager.getInstance().removeProcessContext(event.getExecutionID());
    }
}

