/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessContext;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.lock.ShowProcessListSimpleLock;

public final class ShowProcessListManager {
    private static final ShowProcessListManager INSTANCE = new ShowProcessListManager();
    private final Map<String, YamlExecuteProcessContext> processContextMap = new ConcurrentHashMap<String, YamlExecuteProcessContext>();
    private final Map<String, ShowProcessListSimpleLock> locks = new ConcurrentHashMap<String, ShowProcessListSimpleLock>();

    public static ShowProcessListManager getInstance() {
        return INSTANCE;
    }

    public void putProcessContext(String executionId, YamlExecuteProcessContext processContext) {
        this.processContextMap.put(executionId, processContext);
    }

    public YamlExecuteProcessContext getProcessContext(String executionId) {
        return this.processContextMap.get(executionId);
    }

    public void removeProcessContext(String executionId) {
        this.processContextMap.remove(executionId);
    }

    public Collection<YamlExecuteProcessContext> getAllProcessContext() {
        return this.processContextMap.values();
    }

    @Generated
    private ShowProcessListManager() {
    }

    @Generated
    public Map<String, ShowProcessListSimpleLock> getLocks() {
        return this.locks;
    }
}

