/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.watcher;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.SchemaVersionChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class MetaDataChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(DatabaseMetaDataNode.getMetaDataNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (this.isLogicDatabaseChanged(event)) {
            return this.createLogicDatabaseChangedEvent(event);
        }
        if (this.isLogicSchemaChanged(event)) {
            return this.createLogicSchemaChangedEvent(event);
        }
        if (this.isTableMetaDataChanged(event)) {
            return this.createSchemaChangedEvent(event);
        }
        if (DataChangedEvent.Type.UPDATED == event.getType()) {
            return this.createUpdateGovernanceEvent(event);
        }
        return Optional.empty();
    }

    private boolean isLogicDatabaseChanged(DataChangedEvent event) {
        return DatabaseMetaDataNode.getDatabaseName((String)event.getKey()).isPresent();
    }

    private boolean isLogicSchemaChanged(DataChangedEvent event) {
        return DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey()).isPresent() && DatabaseMetaDataNode.getSchemaName((String)event.getKey()).isPresent();
    }

    private boolean isTableMetaDataChanged(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Optional schemaName = DatabaseMetaDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        Optional tableName = DatabaseMetaDataNode.getTableName((String)event.getKey());
        return databaseName.isPresent() && tableName.isPresent() && schemaName.isPresent() && !SystemSchemaBuilderRule.isSystemTable((String)((String)databaseName.get()), (String)((String)tableName.get())) && !Strings.isNullOrEmpty((String)event.getValue());
    }

    private Optional<GovernanceEvent> createLogicDatabaseChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseName((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new DatabaseAddedEvent((String)databaseName.get()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new DatabaseDeletedEvent((String)databaseName.get()));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createLogicSchemaChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        Optional schemaName = DatabaseMetaDataNode.getSchemaName((String)event.getKey());
        Preconditions.checkState((boolean)schemaName.isPresent());
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new SchemaAddedEvent((String)databaseName.get(), (String)schemaName.get()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new SchemaDeletedEvent((String)databaseName.get(), (String)schemaName.get()));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createUpdateGovernanceEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        if (!databaseName.isPresent() || Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        if (event.getKey().equals(DatabaseMetaDataNode.getActiveVersionPath((String)((String)databaseName.get())))) {
            return Optional.of(new SchemaVersionChangedEvent((String)databaseName.get(), event.getValue()));
        }
        Optional schemaVersion = DatabaseMetaDataNode.getVersionByDataSourcesPath((String)event.getKey());
        if (schemaVersion.isPresent()) {
            return Optional.of(this.createDataSourceChangedEvent((String)databaseName.get(), (String)schemaVersion.get(), event));
        }
        return DatabaseMetaDataNode.getVersionByRulesPath((String)event.getKey()).map(optional -> new RuleConfigurationsChangedEvent((String)databaseName.get(), (String)optional, this.getRuleConfigurations(event.getValue())));
    }

    private DataSourceChangedEvent createDataSourceChangedEvent(String databaseName, String schemaVersion, DataChangedEvent event) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)event.getValue(), Map.class);
        HashMap<String, DataSourceProperties> dataSourcePropertiesMap = yamlDataSources.isEmpty() ? new HashMap<String, DataSourceProperties>() : (Map)yamlDataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties((Map)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return new DataSourceChangedEvent(databaseName, schemaVersion, dataSourcePropertiesMap);
    }

    private Collection<RuleConfiguration> getRuleConfigurations(String yamlContent) {
        LinkedList rules = Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class, (boolean)true);
        return new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(rules);
    }

    private Optional<GovernanceEvent> createSchemaChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        Optional schemaName = DatabaseMetaDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        Preconditions.checkState((boolean)schemaName.isPresent());
        Optional tableName = DatabaseMetaDataNode.getTableName((String)event.getKey());
        Preconditions.checkState((boolean)tableName.isPresent());
        return Optional.of(this.createSchemaChangedEvent(event, (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get()));
    }

    private SchemaChangedEvent createSchemaChangedEvent(DataChangedEvent event, String databaseName, String schemaName, String tableName) {
        return DataChangedEvent.Type.DELETED == event.getType() ? new SchemaChangedEvent(databaseName, schemaName, null, tableName) : new SchemaChangedEvent(databaseName, schemaName, new TableMetaDataYamlSwapper().swapToObject((YamlTableMetaData)YamlEngine.unmarshal((String)event.getValue(), YamlTableMetaData.class)), null);
    }
}

