/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.subscriber;

import com.google.common.eventbus.Subscribe;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AddSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AlterSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropIndexEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaMetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class SchemaMetaDataRegistrySubscriber {
    private final SchemaMetaDataPersistService persistService;

    public SchemaMetaDataRegistrySubscriber(ClusterPersistRepository repository) {
        this.persistService = new SchemaMetaDataPersistService((PersistRepository)repository);
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(SchemaAlteredEvent event) {
        event.getAlteredTables().forEach(each -> this.persistService.persistTable(event.getDatabaseName(), event.getSchemaName(), each));
        event.getDroppedTables().forEach(each -> this.persistService.deleteTable(event.getDatabaseName(), event.getSchemaName(), each));
    }

    @Subscribe
    public void addSchema(AddSchemaEvent event) {
        this.persistService.persistSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public void alterSchema(AlterSchemaEvent event) {
        this.persistService.persistMetaData(event.getDatabaseName(), event.getRenameSchemaName(), event.getSchema());
        this.persistService.deleteSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public void dropSchema(DropSchemaEvent event) {
        event.getSchemaNames().forEach(each -> this.persistService.deleteSchema(event.getDatabaseName(), each));
    }

    @Subscribe
    public void dropIndex(DropIndexEvent event) {
        event.getSchemaAlteredEvents().forEach(this::update);
    }
}

