/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.subscriber;

import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.event.StartScalingEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingTaskFinishedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.MetadataVersionPreparedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.DatabaseVersionPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingRegistrySubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingRegistrySubscriber.class);
    private final ClusterPersistRepository repository;
    private final DatabaseVersionPersistService databaseVersionPersistService;

    public ScalingRegistrySubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        this.databaseVersionPersistService = new DatabaseVersionPersistService((PersistRepository)repository);
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void startScaling(MetadataVersionPreparedEvent event) {
        String databaseName = event.getDatabaseName();
        String activeVersion = (String)this.databaseVersionPersistService.getDatabaseActiveVersion(databaseName).get();
        String sourceDataSource = this.repository.get(DatabaseMetaDataNode.getMetaDataDataSourcePath((String)databaseName, (String)activeVersion));
        String targetDataSource = this.repository.get(DatabaseMetaDataNode.getMetaDataDataSourcePath((String)databaseName, (String)event.getVersion()));
        String sourceRule = this.repository.get(DatabaseMetaDataNode.getRulePath((String)databaseName, (String)activeVersion));
        String targetRule = this.repository.get(DatabaseMetaDataNode.getRulePath((String)databaseName, (String)event.getVersion()));
        log.info("start scaling job, locked the schema name, event={}", (Object)event);
        StartScalingEvent startScalingEvent = new StartScalingEvent(databaseName, sourceDataSource, sourceRule, targetDataSource, targetRule, Integer.parseInt(activeVersion), Integer.parseInt(event.getVersion()));
        ShardingSphereEventBus.getInstance().post((Object)startScalingEvent);
    }

    @Subscribe
    public void scalingTaskFinished(ScalingTaskFinishedEvent event) {
        log.info("scalingTaskFinished, event={}", (Object)event);
        int targetActiveVersion = event.getTargetActiveVersion();
        Optional activeVersion = this.databaseVersionPersistService.getDatabaseActiveVersion(event.getTargetSchemaName());
        if (activeVersion.isPresent() && targetActiveVersion == Integer.parseInt((String)activeVersion.get())) {
            this.databaseVersionPersistService.persistActiveVersion(event.getTargetSchemaName(), event.getTargetNewVersion() + "");
            this.databaseVersionPersistService.deleteVersion(event.getTargetSchemaName(), targetActiveVersion + "");
        } else {
            log.error("targetActiveVersion does not match current activeVersion, targetActiveVersion={}, activeVersion={}", (Object)targetActiveVersion, activeVersion.orElse(null));
        }
    }
}

