/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeUtil;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class MutexLockRegistryService
implements LockRegistryService {
    private final ClusterPersistRepository repository;

    @Override
    public Collection<String> acquireAckLockedInstances(String ackLockName) {
        return this.repository.getChildrenKeys(ackLockName);
    }

    @Override
    public boolean tryLock(String lockName, long timeoutMilliseconds) {
        try {
            return this.repository.getInternalMutexLock(lockName).tryLock(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignore) {
            return false;
        }
    }

    @Override
    public void releaseLock(String lockName) {
        this.repository.getInternalMutexLock(lockName).unlock();
    }

    @Override
    public void removeLock(String lockName) {
        this.repository.delete(LockNodeUtil.generateLockLeasesNodePath(lockName));
    }

    @Override
    public void ackLock(String lockName, String lockValue) {
        this.repository.persistEphemeral(lockName, lockValue);
    }

    @Override
    public void releaseAckLock(String lockName) {
        this.repository.delete(lockName);
    }

    @Generated
    public MutexLockRegistryService(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

