/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.InterMutexLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.InterReentrantMutexLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.MutexLockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeType;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ShardingSphereInterMutexLockHolder {
    private final Map<String, InterMutexLock> interMutexLocks = new LinkedHashMap<String, InterMutexLock>();
    private final Map<String, InterReentrantMutexLock> interReentrantMutexLocks = new LinkedHashMap<String, InterReentrantMutexLock>();
    private final ClusterPersistRepository repository;
    private final LockRegistryService mutexLockRegistryService;
    private final ComputeNodeInstance currentInstance;
    private final Collection<ComputeNodeInstance> computeNodeInstances;

    public ShardingSphereInterMutexLockHolder(ClusterPersistRepository repository, ComputeNodeInstance instance, Collection<ComputeNodeInstance> nodeInstances) {
        this.repository = repository;
        this.mutexLockRegistryService = new MutexLockRegistryService(repository);
        this.currentInstance = instance;
        this.computeNodeInstances = nodeInstances;
    }

    public synchronized InterMutexLock getOrCreateInterMutexLock(String locksName) {
        InterMutexLock result = this.interMutexLocks.get(locksName);
        if (null == result) {
            result = this.createInterMutexLock(locksName);
            this.interMutexLocks.put(locksName, result);
        }
        return result;
    }

    private InterMutexLock createInterMutexLock(String locksName) {
        InterReentrantMutexLock interReentrantMutexLock = this.getInterReentrantMutexLock(locksName + "/sequence");
        return new InterMutexLock(locksName, interReentrantMutexLock, this.mutexLockRegistryService, this.currentInstance, this.computeNodeInstances);
    }

    public Optional<InterMutexLock> getInterMutexLock(String locksName) {
        if (this.interMutexLocks.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.interMutexLocks.get(locksName));
    }

    public InterReentrantMutexLock getInterReentrantMutexLock(String locksName) {
        InterReentrantMutexLock result = this.interReentrantMutexLocks.get(locksName);
        if (null == result) {
            result = new InterReentrantMutexLock(this.repository.getInternalReentrantMutexLock(locksName));
            this.interReentrantMutexLocks.put(locksName, result);
        }
        return result;
    }

    public void synchronizeMutexLock(LockNodeService lockNodeService) {
        List allGlobalLock = this.repository.getChildrenKeys(lockNodeService.getLocksNodePath());
        if (allGlobalLock.isEmpty()) {
            if (LockNodeType.DISTRIBUTED == lockNodeService.getType()) {
                return;
            }
            this.repository.persist(lockNodeService.getLocksNodePath(), "");
            return;
        }
        for (String each : allGlobalLock) {
            Optional<String> generalLock = lockNodeService.parseLocksNodePath(each);
            generalLock.ifPresent(optional -> this.interMutexLocks.put((String)optional, this.createInterMutexLock((String)optional)));
        }
    }

    public String getCurrentInstanceId() {
        return this.currentInstance.getCurrentInstanceId();
    }
}

