/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.lock.LockState;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.LockAckAble;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.MutexLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeUtil;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.TimeoutMilliseconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterMutexLock
implements MutexLock,
LockAckAble {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InterMutexLock.class);
    private final String lockName;
    private final MutexLock sequence;
    private final LockRegistryService lockService;
    private final ComputeNodeInstance currentInstance;
    private final Collection<ComputeNodeInstance> computeNodeInstances;
    private final AtomicBoolean isOwner = new AtomicBoolean(false);
    private final AtomicReference<LockState> synchronizedLockState = new AtomicReference<LockState>(LockState.UNLOCKED);
    private final Set<String> lockedInstances = new CopyOnWriteArraySet<String>();

    @Override
    public boolean tryLock() {
        return this.tryLock(180000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long timeoutMillis) {
        if (!this.sequence.tryLock(50L)) {
            log.debug("Inter mutex sequence lock acquire sequenced failed, lock name: {}", (Object)this.lockName);
            return false;
        }
        try {
            long timeoutMilliseconds = Math.max(timeoutMillis, 200L);
            log.debug("Inter mutex sequence lock acquire sequenced success, lock name: {}, timeout milliseconds: {}ms", (Object)this.lockName, (Object)timeoutMilliseconds);
            boolean bl = this.innerTryLock(this.lockName, timeoutMilliseconds);
            return bl;
        }
        finally {
            this.sequence.unlock();
            log.debug("Inter mutex sequence lock release sequenced success, database name: {}", (Object)this.lockName);
        }
    }

    private boolean innerTryLock(String lockName, long timeout) {
        if (!this.synchronizedLockState.compareAndSet(LockState.UNLOCKED, LockState.LOCKING)) {
            log.debug("Inter mutex lock try Lock set lock state failed, lock name: {}, lock state: {}", (Object)lockName, (Object)this.synchronizedLockState.get().name());
            return false;
        }
        if (!this.isOwner.compareAndSet(false, true)) {
            log.debug("Inter mutex lock try Lock set lock owner failed, lock name: {}, lock is owner: {}", (Object)lockName, (Object)this.isOwner.get());
            return false;
        }
        if (this.acquire(lockName, timeout) && this.synchronizedLockState.compareAndSet(LockState.LOCKING, LockState.LOCKED)) {
            log.debug("Inter mutex lock try Lock acquire lock success, lock name: {}", (Object)lockName);
            return true;
        }
        this.reSetLockState();
        log.debug("Inter mutex lock try Lock acquire lock failed, lock name: {}", (Object)lockName);
        return false;
    }

    private boolean acquire(String lockName, long timeout) {
        long acquireStart = System.currentTimeMillis();
        boolean isLocked = this.lockService.tryLock(lockName, timeout);
        if (isLocked) {
            this.lockedInstances.add(this.currentInstance.getCurrentInstanceId());
            long acquireEnd = System.currentTimeMillis();
            long acquireExpend = acquireEnd - acquireStart;
            log.debug("inter mutex lock acquire lock success then await for ack, lock name: {}, expend time millis {}ms", (Object)lockName, (Object)acquireExpend);
            if (this.isAckOK(timeout - acquireExpend)) {
                long ackExpend = System.currentTimeMillis() - acquireEnd;
                log.debug("inter mutex lock acquire lock success and ack success, lock name: {}, expend time millis {}ms", (Object)lockName, (Object)ackExpend);
                return true;
            }
            this.lockService.releaseLock(lockName);
            return false;
        }
        log.debug("inter mutex lock acquire lock timeout. lock name: {}, timeout millis {}ms", (Object)lockName, (Object)timeout);
        return false;
    }

    private boolean isAckOK(long timeout) {
        long expend = 0L;
        do {
            if (this.isAckCompleted(expend)) {
                return true;
            }
            TimeoutMilliseconds.sleepInterval(50L);
        } while (timeout > (expend += 50L));
        log.debug("inter mutex ack lock timeout, timeout millis {}ms", (Object)timeout);
        return false;
    }

    private boolean isAckCompleted(long expend) {
        if (expend > 100L) {
            this.lockedInstances.addAll(this.lockService.acquireAckLockedInstances(LockNodeUtil.generateAckPathName(this.lockName)));
        }
        if (this.computeNodeInstances.size() > this.lockedInstances.size()) {
            return false;
        }
        for (ComputeNodeInstance each : this.computeNodeInstances) {
            if (this.lockedInstances.contains(each.getInstanceDefinition().getInstanceId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unlock() {
        LockState lockState = this.synchronizedLockState.get();
        if (LockState.LOCKED == lockState) {
            log.debug("inter mutex lock unlock. lock name: {}", (Object)this.lockName);
            if (this.isOwner.get()) {
                this.lockService.releaseLock(this.lockName);
                log.debug("inter mutex lock owner lock release lock success. lock name: {}", (Object)this.lockName);
            } else {
                this.lockService.removeLock(this.lockName);
                log.debug("inter mutex lock not owner remove lock success. lock name: {}", (Object)this.lockName);
            }
            this.reSetLockState();
            return;
        }
        log.debug("inter mutex lock ignore unlock, lock name: {} lock state: {}", (Object)this.lockName, (Object)lockState);
    }

    @Override
    public boolean isLocked() {
        return LockState.LOCKED == this.synchronizedLockState.get();
    }

    @Override
    public void ackLock(String ackLockName, String lockedInstanceId) {
        LockState lockState = this.synchronizedLockState.get();
        boolean owner = this.isOwner.get();
        if (!owner && LockState.UNLOCKED == lockState) {
            this.lockService.ackLock(ackLockName, lockedInstanceId);
            this.lockedInstances.add(lockedInstanceId);
            this.synchronizedLockState.compareAndSet(LockState.UNLOCKED, LockState.LOCKED);
            log.debug("inter mutex lock ack lock success, ack lock name: {}", (Object)ackLockName);
        }
        log.debug("inter mutex lock ignore ack lock, ack lock name: {}, lock state: {}, lock owner: {}", new Object[]{ackLockName, lockState, owner});
    }

    @Override
    public void releaseAckLock(String ackLockName, String lockedInstanceId) {
        boolean owner = this.isOwner.get();
        if (!owner) {
            this.lockService.releaseAckLock(ackLockName);
            log.debug("inter mutex lock not owner release ack lock success, ack lock name: {}, locked instanceId: {}", (Object)ackLockName, (Object)lockedInstanceId);
        }
        this.reSetLockState();
    }

    @Override
    public void addLockedInstance(String lockedInstanceId) {
        this.lockedInstances.add(lockedInstanceId);
        log.debug("inter mutex lock add locked instance id, id: {}", (Object)lockedInstanceId);
    }

    @Override
    public void removeLockedInstance(String lockedInstanceId) {
        this.lockedInstances.remove(lockedInstanceId);
        log.debug("inter mutex lock remove locked instance id, id: {}", (Object)lockedInstanceId);
    }

    @Override
    public void reSetLockState() {
        this.lockedInstances.clear();
        this.isOwner.set(false);
        this.synchronizedLockState.set(LockState.UNLOCKED);
    }

    @Generated
    public InterMutexLock(String lockName, MutexLock sequence, LockRegistryService lockService, ComputeNodeInstance currentInstance, Collection<ComputeNodeInstance> computeNodeInstances) {
        this.lockName = lockName;
        this.sequence = sequence;
        this.lockService = lockService;
        this.currentInstance = currentInstance;
        this.computeNodeInstances = computeNodeInstances;
    }
}

