/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.manager;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.infra.lock.LockMode;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.ShardingSphereDistributedDatabaseLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.ShardingSphereDistributedLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.manager.ShardingSphereLockManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.ShardingSphereInterMutexLockHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedLockManager
implements ShardingSphereLockManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributedLockManager.class);
    private ShardingSphereDistributedLock distributedLock;
    private ShardingSphereDistributedDatabaseLock databaseLock;

    @Override
    public void init(ShardingSphereInterMutexLockHolder lockHolder) {
        this.distributedLock = new ShardingSphereDistributedLock(lockHolder);
        this.databaseLock = new ShardingSphereDistributedDatabaseLock(lockHolder);
    }

    @Override
    public ShardingSphereLock getDistributedLock() {
        return this.distributedLock;
    }

    @Override
    public boolean tryLock(String databaseName, LockMode lockMode) {
        return this.innerTryLock(databaseName, lockMode, 180000L);
    }

    @Override
    public boolean tryLock(String databaseName, LockMode lockMode, long timeoutMilliseconds) {
        return this.innerTryLock(databaseName, lockMode, timeoutMilliseconds);
    }

    private synchronized boolean innerTryLock(String databaseName, LockMode lockMode, long timeoutMilliseconds) {
        switch (lockMode) {
            case READ: {
                return this.innerDatabaseTryLock(databaseName, timeoutMilliseconds);
            }
        }
        throw new UnsupportedOperationException();
    }

    private boolean innerDatabaseTryLock(String databaseName, long timeoutMilliseconds) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"Try Lock write for database args database name can not be null.");
        log.debug("Distribute database lock acquire sequenced success, database name: {}", (Object)databaseName);
        return this.databaseLock.tryLock(databaseName, timeoutMilliseconds - 50L);
    }

    @Override
    public void releaseLock(String databaseName) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"Release lock write args database name can not be null.");
        this.databaseLock.releaseLock(databaseName);
    }

    @Override
    public boolean isLocked(String databaseName) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"Is locked database args database name can not be null.");
        return this.databaseLock.isLocked(databaseName);
    }
}

