/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.watcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeServiceFactory;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedAckLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedAckLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeType;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class DistributedLockChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    private final LockNodeService lockNode = LockNodeServiceFactory.getInstance().getLockNodeService(LockNodeType.DISTRIBUTED);

    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(this.lockNode.getLocksNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        Optional<String> lockedName = this.lockNode.parseLocksNodePath(event.getKey());
        if (lockedName.isPresent()) {
            return this.handleMutexLocksEvent(event.getType(), lockedName.get());
        }
        lockedName = this.lockNode.parseLocksAckNodePath(event.getKey());
        if (lockedName.isPresent()) {
            return this.handleMutexLocksAckEvent(event.getType(), lockedName.get());
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> handleMutexLocksEvent(DataChangedEvent.Type eventType, String lockedName) {
        if (DataChangedEvent.Type.ADDED == eventType) {
            return Optional.of(new DistributedLockedEvent(lockedName));
        }
        if (DataChangedEvent.Type.DELETED == eventType) {
            return Optional.of(new DistributedLockReleasedEvent(lockedName));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> handleMutexLocksAckEvent(DataChangedEvent.Type eventType, String ackLockedName) {
        if (DataChangedEvent.Type.ADDED == eventType) {
            return Optional.of(new DistributedAckLockedEvent(ackLockedName));
        }
        if (DataChangedEvent.Type.DELETED == eventType) {
            return Optional.of(new DistributedAckLockReleasedEvent(ackLockedName));
        }
        return Optional.empty();
    }
}

