/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed;

import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeServiceFactory;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedAckLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedAckLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.distributed.event.DistributedLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.InterMutexLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.ShardingSphereInterMutexLockHolder;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereDistributedLock
implements ShardingSphereLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereDistributedLock.class);
    private final LockNodeService lockNodeService = LockNodeServiceFactory.getInstance().getLockNodeService(LockNodeType.DISTRIBUTED);
    private final ShardingSphereInterMutexLockHolder lockHolder;

    public ShardingSphereDistributedLock(ShardingSphereInterMutexLockHolder lockHolder) {
        this.lockHolder = lockHolder;
        ShardingSphereEventBus.getInstance().register((Object)this);
        this.syncMutexLockStatus();
    }

    private void syncMutexLockStatus() {
        this.lockHolder.synchronizeMutexLock(this.lockNodeService);
    }

    public boolean tryLock(String lockName) {
        return this.tryLock(lockName, 180000L);
    }

    public boolean tryLock(String lockName, long timeoutMillis) {
        return this.innerTryLock(lockName, timeoutMillis);
    }

    private boolean innerTryLock(String lockName, long timeoutMillis) {
        return this.lockHolder.getOrCreateInterMutexLock(this.lockNodeService.generateLocksName(lockName)).tryLock(timeoutMillis);
    }

    private Optional<InterMutexLock> getInterMutexLock(String lockName) {
        return this.lockHolder.getInterMutexLock(this.lockNodeService.generateLocksName(lockName));
    }

    public void releaseLock(String lockName) {
        this.getInterMutexLock(lockName).ifPresent(InterMutexLock::unlock);
    }

    public boolean isLocked(String lockName) {
        return this.getInterMutexLock(lockName).map(InterMutexLock::isLocked).orElse(false);
    }

    @Subscribe
    public synchronized void locked(DistributedLockedEvent event) {
        String lockName = event.getLockedName();
        String lockedInstanceId = this.lockHolder.getCurrentInstanceId();
        InterMutexLock interMutexLock = this.lockHolder.getOrCreateInterMutexLock(this.lockNodeService.generateLocksName(lockName));
        interMutexLock.ackLock(this.lockNodeService.generateAckLockName(lockName, lockedInstanceId), lockedInstanceId);
    }

    @Subscribe
    public synchronized void lockReleased(DistributedLockReleasedEvent event) {
        String lockName = event.getLockedName();
        String lockedInstanceId = this.lockHolder.getCurrentInstanceId();
        this.getInterMutexLock(lockName).ifPresent(mutexLock -> mutexLock.releaseAckLock(this.lockNodeService.generateAckLockName(lockName, lockedInstanceId), lockedInstanceId));
    }

    @Subscribe
    public synchronized void ackLocked(DistributedAckLockedEvent event) {
        this.getInterMutexLock(event.getLockName()).ifPresent(mutexLock -> mutexLock.addLockedInstance(event.getLockedInstance()));
    }

    @Subscribe
    public synchronized void ackLockReleased(DistributedAckLockReleasedEvent event) {
        this.getInterMutexLock(event.getLockName()).ifPresent(mutexLock -> mutexLock.removeLockedInstance(event.getLockedInstance()));
    }
}

