/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.watcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeServiceFactory;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseAckLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseAckLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeType;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class DatabaseLockChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    private final LockNodeService lockNode = LockNodeServiceFactory.getInstance().getLockNodeService(LockNodeType.DATABASE);

    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(this.lockNode.getLocksNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        Optional<String> lockedName = this.lockNode.parseLocksNodePath(event.getKey());
        if (lockedName.isPresent()) {
            return this.handleDatabaseLocksEvent(event.getType(), lockedName.get());
        }
        lockedName = this.lockNode.parseLocksAckNodePath(event.getKey());
        if (lockedName.isPresent()) {
            return this.handleDatabaseLocksAckEvent(event.getType(), lockedName.get());
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> handleDatabaseLocksEvent(DataChangedEvent.Type eventType, String lockedName) {
        if (DataChangedEvent.Type.ADDED == eventType) {
            return Optional.of(new DatabaseLockedEvent(lockedName));
        }
        if (DataChangedEvent.Type.DELETED == eventType) {
            return Optional.of(new DatabaseLockReleasedEvent(lockedName));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> handleDatabaseLocksAckEvent(DataChangedEvent.Type eventType, String ackLockedName) {
        if (DataChangedEvent.Type.ADDED == eventType) {
            return Optional.of(new DatabaseAckLockedEvent(ackLockedName));
        }
        if (DataChangedEvent.Type.DELETED == eventType) {
            return Optional.of(new DatabaseAckLockReleasedEvent(ackLockedName));
        }
        return Optional.empty();
    }
}

