/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database;

import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeServiceFactory;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseAckLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseAckLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseLockReleasedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.database.event.DatabaseLockedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.InterMutexLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.ShardingSphereInterMutexLockHolder;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeType;

public final class ShardingSphereDistributedDatabaseLock
implements ShardingSphereLock {
    private final LockNodeService lockNodeService = LockNodeServiceFactory.getInstance().getLockNodeService(LockNodeType.DATABASE);
    private final ShardingSphereInterMutexLockHolder lockHolder;

    public ShardingSphereDistributedDatabaseLock(ShardingSphereInterMutexLockHolder lockHolder) {
        this.lockHolder = lockHolder;
        ShardingSphereEventBus.getInstance().register((Object)this);
        lockHolder.synchronizeMutexLock(this.lockNodeService);
    }

    public boolean tryLock(String lockName) {
        return this.tryLock(lockName, 180000L);
    }

    public boolean tryLock(String lockName, long timeoutMillis) {
        return this.innerTryLock(lockName, timeoutMillis);
    }

    private boolean innerTryLock(String lockName, long timeoutMillis) {
        return this.lockHolder.getOrCreateInterMutexLock(this.lockNodeService.generateLocksName(lockName)).tryLock(timeoutMillis);
    }

    private Optional<InterMutexLock> getInterMutexLock(String lockName) {
        return this.lockHolder.getInterMutexLock(this.lockNodeService.generateLocksName(lockName));
    }

    public void releaseLock(String lockName) {
        this.getInterMutexLock(lockName).ifPresent(InterMutexLock::unlock);
    }

    public boolean isLocked(String lockName) {
        return this.getInterMutexLock(lockName).map(InterMutexLock::isLocked).orElse(false);
    }

    @Subscribe
    public synchronized void locked(DatabaseLockedEvent event) {
        String database = event.getDatabase();
        String lockedInstanceId = this.lockHolder.getCurrentInstanceId();
        InterMutexLock interMutexLock = this.lockHolder.getOrCreateInterMutexLock(this.lockNodeService.generateLocksName(database));
        interMutexLock.ackLock(this.lockNodeService.generateAckLockName(database, lockedInstanceId), lockedInstanceId);
    }

    @Subscribe
    public synchronized void lockReleased(DatabaseLockReleasedEvent event) {
        String database = event.getDatabase();
        String lockedInstanceId = this.lockHolder.getCurrentInstanceId();
        this.getInterMutexLock(database).ifPresent(mutexLock -> mutexLock.releaseAckLock(this.lockNodeService.generateAckLockName(database, lockedInstanceId), lockedInstanceId));
    }

    @Subscribe
    public synchronized void ackLocked(DatabaseAckLockedEvent event) {
        this.getInterMutexLock(event.getDatabase()).ifPresent(mutexLock -> mutexLock.addLockedInstance(event.getLockedInstance()));
    }

    @Subscribe
    public synchronized void ackLockReleased(DatabaseAckLockReleasedEvent event) {
        this.getInterMutexLock(event.getDatabase()).ifPresent(mutexLock -> mutexLock.removeLockedInstance(event.getLockedInstance()));
    }
}

