/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock;

import java.util.EnumMap;
import java.util.Map;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.util.LockNodeType;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class LockNodeServiceFactory {
    private static final Map<LockNodeType, LockNodeService> SERVICES;
    private static final LockNodeServiceFactory INSTANCE;

    private LockNodeServiceFactory() {
        this.loadLockNodeService();
    }

    private void loadLockNodeService() {
        for (LockNodeService each : ShardingSphereServiceLoader.getServiceInstances(LockNodeService.class)) {
            LockNodeType type = each.getType();
            if (SERVICES.containsKey((Object)type)) continue;
            SERVICES.put(type, each);
        }
    }

    public static LockNodeServiceFactory getInstance() {
        return INSTANCE;
    }

    public LockNodeService getLockNodeService(LockNodeType lockNodeType) {
        return SERVICES.get((Object)lockNodeType);
    }

    static {
        ShardingSphereServiceLoader.register(LockNodeService.class);
        SERVICES = new EnumMap<LockNodeType, LockNodeService>(LockNodeType.class);
        INSTANCE = new LockNodeServiceFactory();
    }
}

