/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock;

import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockMode;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.manager.ShardingSphereLockManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.mutex.ShardingSphereInterMutexLockHolder;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.type.required.RequiredSPIRegistry;

public final class DistributedLockContext
implements LockContext {
    private final ClusterPersistRepository repository;
    private ShardingSphereLockManager lockManager;

    public void initLockState(InstanceContext instanceContext) {
        this.loadLockManager(new ShardingSphereInterMutexLockHolder(this.repository, instanceContext.getInstance(), instanceContext.getComputeNodeInstances()));
    }

    private void loadLockManager(ShardingSphereInterMutexLockHolder lockHolder) {
        this.lockManager = (ShardingSphereLockManager)RequiredSPIRegistry.getRegisteredService(ShardingSphereLockManager.class);
        this.lockManager.init(lockHolder);
    }

    public ShardingSphereLock getLock() {
        return this.lockManager.getDistributedLock();
    }

    public boolean tryLock(String databaseName, LockMode lockMode) {
        return this.lockManager.tryLock(databaseName, lockMode);
    }

    public boolean tryLock(String databaseName, Set<String> schemaNames, LockMode lockMode) {
        return this.lockManager.tryLock(databaseName, schemaNames, lockMode);
    }

    public boolean tryLock(String databaseName, LockMode lockMode, long timeoutMilliseconds) {
        return this.lockManager.tryLock(databaseName, lockMode, timeoutMilliseconds);
    }

    public boolean tryLock(String databaseName, Set<String> schemaNames, LockMode lockMode, long timeoutMilliseconds) {
        return this.lockManager.tryLock(databaseName, schemaNames, lockMode, timeoutMilliseconds);
    }

    public void releaseLock(String databaseName) {
        this.lockManager.releaseLock(databaseName);
    }

    public void releaseLock(String databaseName, String schemaName) {
        this.lockManager.releaseLock(databaseName, schemaName);
    }

    public boolean isLocked(String databaseName) {
        return this.lockManager.isLocked(databaseName);
    }

    @Generated
    public DistributedLockContext(ClusterPersistRepository repository) {
        this.repository = repository;
    }

    static {
        ShardingSphereServiceLoader.register(ShardingSphereLockManager.class);
    }
}

