/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.LockNodeService;

public abstract class AbstractDistributedLockNodeService
implements LockNodeService {
    @Override
    public String getLocksNodePath() {
        return "/lock/" + this.getLockTypeName() + "/" + "locks";
    }

    @Override
    public String generateLocksName(String locksName) {
        return this.getLocksNodePath() + "/" + locksName;
    }

    @Override
    public String generateAckLockName(String lockName, String lockedInstanceId) {
        return this.getLocksNodePath() + "/" + lockName + "/" + "ack" + "/" + lockedInstanceId;
    }

    @Override
    public Optional<String> parseLocksNodePath(String nodePath) {
        Pattern pattern = Pattern.compile(this.getLocksNodePath() + "/(.+)/leases/(.+)$", 2);
        Matcher matcher = pattern.matcher(nodePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    @Override
    public Optional<String> parseLocksAckNodePath(String nodePath) {
        Pattern pattern = Pattern.compile(this.getLocksNodePath() + "/(.+)/ack/(.+)$", 2);
        Matcher matcher = pattern.matcher(nodePath);
        return matcher.find() ? Optional.of(matcher.group(1) + "#@#" + matcher.group(2)) : Optional.empty();
    }

    protected abstract String getLockTypeName();
}

