/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.BatchYamlExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessContext;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.GlobalRuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.SchemaVersionChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.ShowProcessListManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.lock.ShowProcessListSimpleLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.node.ProcessNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListTriggerEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListUnitCompleteEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.StateEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.WorkerIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.XaRecoveryIdDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.PrimaryStateChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;

public final class ClusterContextManagerCoordinator {
    private final MetaDataPersistService metaDataPersistService;
    private final ContextManager contextManager;
    private final RegistryCenter registryCenter;

    public ClusterContextManagerCoordinator(MetaDataPersistService metaDataPersistService, ContextManager contextManager, RegistryCenter registryCenter) {
        this.metaDataPersistService = metaDataPersistService;
        this.contextManager = contextManager;
        this.registryCenter = registryCenter;
        ShardingSphereEventBus.getInstance().register((Object)this);
        this.buildSpecialRules();
    }

    @Subscribe
    public synchronized void renew(DatabaseAddedEvent event) throws SQLException {
        this.contextManager.addDatabase(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(DatabaseDeletedEvent event) {
        this.contextManager.deleteDatabase(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) {
        this.contextManager.addSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        this.contextManager.dropSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        this.contextManager.alterProperties(event.getProps());
    }

    @Subscribe
    public synchronized void renew(SchemaChangedEvent event) {
        this.contextManager.alterSchema(event.getDatabaseName(), event.getSchemaName(), event.getChangedTableMetaData(), event.getDeletedTable());
    }

    @Subscribe
    public synchronized void renew(RuleConfigurationsChangedEvent event) {
        if (this.metaDataPersistService.getDatabaseVersionPersistService().isActiveVersion(event.getDatabaseName(), event.getDatabaseVersion())) {
            this.contextManager.alterRuleConfiguration(event.getDatabaseName(), event.getRuleConfigurations());
            this.buildSpecialRules();
        }
    }

    @Subscribe
    public synchronized void renew(DataSourceChangedEvent event) {
        if (this.metaDataPersistService.getDatabaseVersionPersistService().isActiveVersion(event.getDatabaseName(), event.getDatabaseVersion())) {
            this.contextManager.alterDataSourceConfiguration(event.getDatabaseName(), event.getDataSourcePropertiesMap());
            this.buildSpecialRules();
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent event) {
        QualifiedDatabase qualifiedDatabase = event.getQualifiedSchema();
        ((ShardingSphereDatabase)this.contextManager.getMetaDataContexts().getMetaData().getDatabases().get(qualifiedDatabase.getDatabaseName())).getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> ((StatusContainedRule)each).updateStatus((DataSourceStatusChangedEvent)new DataSourceNameDisabledEvent(qualifiedDatabase, event.isDisabled())));
    }

    @Subscribe
    public synchronized void renew(PrimaryStateChangedEvent event) {
        QualifiedDatabase qualifiedDatabase = event.getQualifiedDatabase();
        ((ShardingSphereDatabase)this.contextManager.getMetaDataContexts().getMetaData().getDatabases().get(qualifiedDatabase.getDatabaseName())).getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> ((StatusContainedRule)each).updateStatus((DataSourceStatusChangedEvent)new PrimaryDataSourceChangedEvent(qualifiedDatabase)));
    }

    @Subscribe
    public synchronized void renew(GlobalRuleConfigurationsChangedEvent event) {
        this.contextManager.alterGlobalRuleConfiguration(event.getRuleConfigurations());
    }

    @Subscribe
    public synchronized void renew(StateEvent event) {
        this.contextManager.getInstanceContext().updateInstanceStatus(event.getInstanceId(), event.getStatus());
    }

    @Subscribe
    public synchronized void renew(WorkerIdEvent event) {
        if (this.contextManager.getInstanceContext().getInstance().getInstanceDefinition().getInstanceId().equals(event.getInstanceId())) {
            this.contextManager.getInstanceContext().updateWorkerId(event.getWorkerId());
        }
    }

    @Subscribe
    public synchronized void renew(LabelsEvent event) {
        this.contextManager.getInstanceContext().updateLabel(event.getInstanceId(), event.getLabels());
    }

    @Subscribe
    public synchronized void renew(XaRecoveryIdAddedEvent event) {
        if (this.contextManager.getInstanceContext().addXaRecoveryId(event.getInstanceId(), event.getXaRecoveryId())) {
            this.contextManager.renewAllTransactionContext();
        }
    }

    @Subscribe
    public synchronized void renew(XaRecoveryIdDeletedEvent event) {
        if (this.contextManager.getInstanceContext().deleteXaRecoveryId(event.getInstanceId(), event.getXaRecoveryId())) {
            this.contextManager.renewAllTransactionContext();
        }
    }

    @Subscribe
    public synchronized void renew(InstanceOnlineEvent event) {
        this.contextManager.getInstanceContext().addComputeNodeInstance(this.registryCenter.getComputeNodeStatusService().loadComputeNodeInstance(event.getInstanceDefinition()));
    }

    @Subscribe
    public synchronized void renew(InstanceOfflineEvent event) {
        this.contextManager.getInstanceContext().deleteComputeNodeInstance(new ComputeNodeInstance(event.getInstanceDefinition()));
    }

    @Subscribe
    public synchronized void renew(SchemaVersionChangedEvent event) {
        Map dataSourcePropertiesMap = this.metaDataPersistService.getDataSourceService().load(event.getDatabaseName(), event.getActiveVersion());
        Collection ruleConfigs = this.metaDataPersistService.getDatabaseRulePersistService().load(event.getDatabaseName(), event.getActiveVersion());
        this.contextManager.alterDataSourceAndRuleConfiguration(event.getDatabaseName(), dataSourcePropertiesMap, ruleConfigs);
    }

    @Subscribe
    public synchronized void triggerShowProcessList(ShowProcessListTriggerEvent event) {
        if (!event.getInstanceId().equals(this.contextManager.getInstanceContext().getInstance().getInstanceDefinition().getInstanceId())) {
            return;
        }
        Collection<YamlExecuteProcessContext> processContexts = ShowProcessListManager.getInstance().getAllProcessContext();
        if (!processContexts.isEmpty()) {
            this.registryCenter.getRepository().persist(ProcessNode.getShowProcessListInstancePath(event.getShowProcessListId(), event.getInstanceId()), YamlEngine.marshal((Object)new BatchYamlExecuteProcessContext(new LinkedList<YamlExecuteProcessContext>(processContexts))));
        }
        this.registryCenter.getRepository().delete(ComputeNode.getProcessTriggerInstanceIdNodePath((String)event.getInstanceId(), (String)event.getShowProcessListId()));
    }

    @Subscribe
    public synchronized void completeUnitShowProcessList(ShowProcessListUnitCompleteEvent event) {
        ShowProcessListSimpleLock simpleLock = ShowProcessListManager.getInstance().getLocks().get(event.getShowProcessListId());
        if (null != simpleLock) {
            simpleLock.doNotify();
        }
    }

    private void buildSpecialRules() {
        this.contextManager.getMetaDataContexts().getMetaData().getDatabases().forEach((key, value) -> value.getRuleMetaData().getRules().forEach(each -> {
            if (each instanceof StatusContainedRule) {
                this.disableDataSources((StatusContainedRule)each);
            }
            if (each instanceof InstanceAwareRule) {
                ((InstanceAwareRule)each).setInstanceContext(this.contextManager.getInstanceContext());
            }
        }));
    }

    private void disableDataSources(StatusContainedRule rule) {
        Map<String, StorageNodeDataSource> storageNodes = this.registryCenter.getStorageNodeStatusService().loadStorageNodes();
        Map<String, StorageNodeDataSource> disableDataSources = storageNodes.entrySet().stream().filter(entry -> StorageNodeStatus.DISABLED.name().toLowerCase().equals(((StorageNodeDataSource)entry.getValue()).getStatus())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        disableDataSources.forEach((key, value) -> rule.updateStatus((DataSourceStatusChangedEvent)new DataSourceNameDisabledEvent(new QualifiedDatabase(key), true)));
    }
}

