/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterContextManagerCoordinator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.DistributedLockContext;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.generator.ClusterWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryFactory;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContextFactory;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.TransactionContextsBuilder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGenerator;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        ModeScheduleContextFactory.getInstance().init(parameter.getInstanceDefinition().getInstanceId(), parameter.getModeConfig());
        ClusterPersistRepository repository = ClusterPersistRepositoryFactory.getInstance((ClusterPersistRepositoryConfiguration)((ClusterPersistRepositoryConfiguration)parameter.getModeConfig().getRepository()));
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(metaDataPersistService, parameter);
        RegistryCenter registryCenter = new RegistryCenter(repository);
        MetaDataContexts metaDataContexts = this.createMetaDataContextsBuilder(metaDataPersistService, parameter).build(metaDataPersistService);
        this.persistMetaData(metaDataContexts);
        Properties transactionProps = this.getTransactionProperties(metaDataContexts);
        this.persistTransactionConfiguration(metaDataPersistService, transactionProps);
        ContextManager result = this.createContextManager(repository, registryCenter, parameter.getInstanceDefinition(), metaDataContexts, transactionProps, parameter.getModeConfig());
        this.registerOnline(metaDataPersistService, parameter, result, registryCenter);
        return result;
    }

    private void persistConfigurations(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        boolean isOverwrite = parameter.getModeConfig().isOverwrite();
        if (!parameter.isEmpty()) {
            metaDataPersistService.persistConfigurations(parameter.getDatabaseConfigs(), parameter.getGlobalRuleConfigs(), parameter.getProps(), isOverwrite);
        }
    }

    private MetaDataContextsBuilder createMetaDataContextsBuilder(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        Set<String> databaseNames = InstanceType.JDBC == parameter.getInstanceDefinition().getInstanceType() ? parameter.getDatabaseConfigs().keySet() : metaDataPersistService.getSchemaMetaDataService().loadAllDatabaseNames();
        Map<String, DatabaseConfiguration> databaseConfigMap = this.getDatabaseConfigMap(databaseNames, metaDataPersistService, parameter);
        Collection globalRuleConfigs = metaDataPersistService.getGlobalRuleService().load();
        ConfigurationProperties props = new ConfigurationProperties(metaDataPersistService.getPropsService().load());
        return new MetaDataContextsBuilder(databaseConfigMap, globalRuleConfigs, props);
    }

    private Properties getTransactionProperties(MetaDataContexts metaDataContexts) {
        Optional fileGenerator;
        Optional databaseName = metaDataContexts.getMetaData().getDatabases().keySet().stream().findFirst();
        Optional<TransactionRule> transactionRule = metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        Optional optional = fileGenerator = transactionRule.isPresent() ? TransactionConfigurationFileGeneratorFactory.findInstance((String)transactionRule.get().getProviderType()) : Optional.empty();
        if (!databaseName.isPresent() || !fileGenerator.isPresent()) {
            return transactionRule.isPresent() ? transactionRule.get().getProps() : new Properties();
        }
        ShardingSphereDatabase database = (ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(databaseName.get());
        Properties result = ((TransactionConfigurationFileGenerator)fileGenerator.get()).getTransactionProps(transactionRule.get().getProps(), (DatabaseConfiguration)new DataSourceProvidedDatabaseConfiguration(database.getResource().getDataSources(), database.getRuleMetaData().getConfigurations()), this.getType());
        Optional transactionRuleConfig = metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRuleConfiguration(TransactionRuleConfiguration.class);
        Preconditions.checkState((boolean)transactionRuleConfig.isPresent());
        ((TransactionRuleConfiguration)transactionRuleConfig.get()).getProps().clear();
        ((TransactionRuleConfiguration)transactionRuleConfig.get()).getProps().putAll((Map<?, ?>)result);
        transactionRule.get().getProps().clear();
        transactionRule.get().getProps().putAll((Map<?, ?>)result);
        return result;
    }

    private void persistTransactionConfiguration(MetaDataPersistService metaDataPersistService, Properties transactionProps) {
        if (!transactionProps.isEmpty()) {
            metaDataPersistService.persistTransactionRule(transactionProps, true);
        }
    }

    private Map<String, DatabaseConfiguration> getDatabaseConfigMap(Collection<String> databaseNames, MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        HashMap<String, DatabaseConfiguration> result = new HashMap<String, DatabaseConfiguration>(databaseNames.size(), 1.0f);
        databaseNames.forEach(each -> result.put((String)each, this.createDatabaseConfiguration((String)each, metaDataPersistService, parameter)));
        return result;
    }

    private DatabaseConfiguration createDatabaseConfiguration(String databaseName, MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        Map dataSources = metaDataPersistService.getEffectiveDataSources(databaseName, parameter.getDatabaseConfigs());
        Collection databaseRuleConfigs = metaDataPersistService.getDatabaseRulePersistService().load(databaseName);
        return new DataSourceProvidedDatabaseConfiguration(dataSources, databaseRuleConfigs);
    }

    private void persistMetaData(MetaDataContexts metaDataContexts) {
        metaDataContexts.getMetaData().getDatabases().forEach((databaseName, schemas) -> schemas.getSchemas().forEach((schemaName, tables) -> metaDataContexts.getPersistService().ifPresent(optional -> optional.getSchemaMetaDataService().persistMetaData(databaseName, schemaName, tables))));
    }

    private ContextManager createContextManager(ClusterPersistRepository repository, RegistryCenter registryCenter, InstanceDefinition instanceDefinition, MetaDataContexts metaDataContexts, Properties transactionProps, ModeConfiguration modeConfig) {
        ClusterWorkerIdGenerator clusterWorkerIdGenerator = new ClusterWorkerIdGenerator(repository, registryCenter, instanceDefinition);
        DistributedLockContext distributedLockContext = new DistributedLockContext(repository);
        InstanceContext instanceContext = new InstanceContext(new ComputeNodeInstance(instanceDefinition), (WorkerIdGenerator)clusterWorkerIdGenerator, modeConfig, (LockContext)distributedLockContext);
        repository.watchSessionConnection(instanceContext);
        this.generateTransactionConfigurationFile(instanceContext, metaDataContexts, transactionProps);
        TransactionContexts transactionContexts = new TransactionContextsBuilder(metaDataContexts.getMetaData().getDatabases(), metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules()).build();
        return new ContextManager(metaDataContexts, transactionContexts, instanceContext);
    }

    private void generateTransactionConfigurationFile(InstanceContext instanceContext, MetaDataContexts metaDataContexts, Properties transactionProps) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getMetaData().getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        if (transactionRule.isPresent()) {
            Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.findInstance((String)transactionRule.get().getProviderType());
            fileGenerator.ifPresent(optional -> optional.generateFile(transactionProps, instanceContext));
        }
    }

    private void registerOnline(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter, ContextManager contextManager, RegistryCenter registryCenter) {
        String instanceId = contextManager.getInstanceContext().getInstance().getCurrentInstanceId();
        contextManager.getInstanceContext().getInstance().getXaRecoveryIds().add(instanceId);
        contextManager.getInstanceContext().getInstance().setLabels(parameter.getLabels());
        contextManager.getInstanceContext().getComputeNodeInstances().addAll(registryCenter.getComputeNodeStatusService().loadAllComputeNodeInstances());
        new ClusterContextManagerCoordinator(metaDataPersistService, contextManager, registryCenter);
        registryCenter.onlineInstance(contextManager.getInstanceContext().getInstance());
    }

    public String getType() {
        return "Cluster";
    }
}

