/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.yaml.config;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityUserConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlShardingSphereAlgorithmConfiguration;

public final class YamlAuthorityConfiguration
implements YamlRuleConfiguration {
    private Collection<YamlAuthorityUserConfiguration> users = new LinkedList<YamlAuthorityUserConfiguration>();
    private YamlShardingSphereAlgorithmConfiguration privilege;
    private Map<String, YamlShardingSphereAlgorithmConfiguration> authenticators = new LinkedHashMap<String, YamlShardingSphereAlgorithmConfiguration>();
    private String defaultAuthenticator;

    public Class<AuthorityRuleConfiguration> getRuleConfigurationType() {
        return AuthorityRuleConfiguration.class;
    }

    public YamlAuthorityRuleConfiguration convertToYamlAuthorityRuleConfiguration() {
        YamlAuthorityRuleConfiguration result = new YamlAuthorityRuleConfiguration();
        result.setUsers(this.users.stream().map(Objects::toString).collect(Collectors.toCollection(LinkedList::new)));
        result.setProvider(this.privilege);
        return result;
    }

    @Generated
    public Collection<YamlAuthorityUserConfiguration> getUsers() {
        return this.users;
    }

    @Generated
    public YamlShardingSphereAlgorithmConfiguration getPrivilege() {
        return this.privilege;
    }

    @Generated
    public Map<String, YamlShardingSphereAlgorithmConfiguration> getAuthenticators() {
        return this.authenticators;
    }

    @Generated
    public String getDefaultAuthenticator() {
        return this.defaultAuthenticator;
    }

    @Generated
    public void setUsers(Collection<YamlAuthorityUserConfiguration> users) {
        this.users = users;
    }

    @Generated
    public void setPrivilege(YamlShardingSphereAlgorithmConfiguration privilege) {
        this.privilege = privilege;
    }

    @Generated
    public void setAuthenticators(Map<String, YamlShardingSphereAlgorithmConfiguration> authenticators) {
        this.authenticators = authenticators;
    }

    @Generated
    public void setDefaultAuthenticator(String defaultAuthenticator) {
        this.defaultAuthenticator = defaultAuthenticator;
    }
}

