/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.rule;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.factory.AuthorityProviderAlgorithmFactory;
import org.apache.shardingsphere.authority.model.AuthorityRegistry;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.spi.AuthorityProviderAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;

public final class AuthorityRule
implements GlobalRule {
    private final Collection<ShardingSphereUser> users;
    private final AuthorityProviderAlgorithm provider;
    private volatile AuthorityRegistry authorityRegistry;

    public AuthorityRule(AuthorityRuleConfiguration config, Map<String, ShardingSphereDatabase> databases) {
        this.users = config.getUsers();
        this.provider = AuthorityProviderAlgorithmFactory.newInstance((ShardingSphereAlgorithmConfiguration)config.getProvider());
        this.authorityRegistry = this.provider.buildAuthorityRegistry(databases, config.getUsers());
    }

    public Optional<ShardingSphereUser> findUser(Grantee grantee) {
        return this.users.stream().filter(each -> each.getGrantee().equals((Object)grantee)).findFirst();
    }

    public Optional<ShardingSpherePrivileges> findPrivileges(Grantee grantee) {
        return this.authorityRegistry.findPrivileges(grantee);
    }

    public synchronized void refresh(Map<String, ShardingSphereDatabase> databases, Collection<ShardingSphereUser> users) {
        this.authorityRegistry = this.provider.buildAuthorityRegistry(databases, users);
    }

    public String getType() {
        return AuthorityRule.class.getSimpleName();
    }
}

