/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.model.privilege;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.AccessSubject;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.admin.AdministrativePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.DatabasePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.subject.DatabaseAccessSubject;
import org.apache.shardingsphere.authority.provider.natived.model.subject.TableAccessSubject;

public final class NativePrivileges
implements ShardingSpherePrivileges {
    private final AdministrativePrivileges administrativePrivileges = new AdministrativePrivileges();
    private final DatabasePrivileges databasePrivileges = new DatabasePrivileges();

    public void setSuperPrivilege() {
        this.administrativePrivileges.getPrivileges().add(PrivilegeType.SUPER);
    }

    public boolean hasPrivileges(String database) {
        return this.administrativePrivileges.getPrivileges().contains(PrivilegeType.SUPER) || !this.databasePrivileges.getGlobalPrivileges().isEmpty() || this.databasePrivileges.getSpecificPrivileges().containsKey(database);
    }

    public boolean hasPrivileges(Collection<PrivilegeType> privileges) {
        return this.administrativePrivileges.hasPrivileges(this.filterPrivileges(privileges));
    }

    public boolean hasPrivileges(AccessSubject accessSubject, Collection<PrivilegeType> privileges) {
        if (accessSubject instanceof DatabaseAccessSubject) {
            return this.hasPrivileges(((DatabaseAccessSubject)accessSubject).getDatabase(), this.filterPrivileges(privileges));
        }
        if (accessSubject instanceof TableAccessSubject) {
            return this.hasPrivileges(((TableAccessSubject)accessSubject).getSchema(), ((TableAccessSubject)accessSubject).getTable(), this.filterPrivileges(privileges));
        }
        throw new UnsupportedOperationException(accessSubject.getClass().getCanonicalName());
    }

    private boolean hasPrivileges(String schema, Collection<PrivilegeType> privileges) {
        return this.administrativePrivileges.hasPrivileges(privileges) || this.databasePrivileges.hasPrivileges(schema, privileges);
    }

    private boolean hasPrivileges(String schema, String table, Collection<PrivilegeType> privileges) {
        return this.administrativePrivileges.hasPrivileges(privileges) || this.databasePrivileges.hasPrivileges(schema, table, privileges);
    }

    private Collection<PrivilegeType> filterPrivileges(Collection<PrivilegeType> privileges) {
        return privileges.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    public AdministrativePrivileges getAdministrativePrivileges() {
        return this.administrativePrivileges;
    }

    @Generated
    public DatabasePrivileges getDatabasePrivileges() {
        return this.databasePrivileges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NativePrivileges)) {
            return false;
        }
        NativePrivileges other = (NativePrivileges)o;
        AdministrativePrivileges this$administrativePrivileges = this.getAdministrativePrivileges();
        AdministrativePrivileges other$administrativePrivileges = other.getAdministrativePrivileges();
        if (this$administrativePrivileges == null ? other$administrativePrivileges != null : !((Object)this$administrativePrivileges).equals(other$administrativePrivileges)) {
            return false;
        }
        DatabasePrivileges this$databasePrivileges = this.getDatabasePrivileges();
        DatabasePrivileges other$databasePrivileges = other.getDatabasePrivileges();
        return !(this$databasePrivileges == null ? other$databasePrivileges != null : !((Object)this$databasePrivileges).equals(other$databasePrivileges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdministrativePrivileges $administrativePrivileges = this.getAdministrativePrivileges();
        result = result * 59 + ($administrativePrivileges == null ? 43 : ((Object)$administrativePrivileges).hashCode());
        DatabasePrivileges $databasePrivileges = this.getDatabasePrivileges();
        result = result * 59 + ($databasePrivileges == null ? 43 : ((Object)$databasePrivileges).hashCode());
        return result;
    }
}

