/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.builder.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.provider.natived.builder.StoragePrivilegeHandler;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.NativePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.SchemaPrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.TablePrivileges;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class PostgreSQLPrivilegeHandler
implements StoragePrivilegeHandler {
    private static final String CREATE_USER_SQL = "CREATE USER %s WITH PASSWORD '%s'";
    private static final String GRANT_ALL_SQL = "ALTER USER %s WITH SUPERUSER";
    private static final String ROLES_SQL = "SELECT * FROM pg_roles WHERE rolname IN (%s)";
    private static final String TABLE_PRIVILEGE_SQL = "SELECT grantor, grantee, table_catalog, table_name, privilege_type, is_grantable FROM information_schema.table_privileges WHERE grantee IN (%s)";

    @Override
    public Collection<ShardingSphereUser> diff(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        LinkedList<Grantee> grantees = new LinkedList<Grantee>();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getRolePrivilegesSQL(users));){
            while (resultSet.next()) {
                grantees.add(new Grantee(resultSet.getString("rolname"), ""));
            }
        }
        return users.stream().filter(each -> !grantees.contains(each.getGrantee())).collect(Collectors.toList());
    }

    @Override
    public void create(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (ShardingSphereUser each : users) {
                statement.execute(this.getCreateUsersSQL(each));
            }
        }
    }

    private String getCreateUsersSQL(ShardingSphereUser user) {
        return String.format(CREATE_USER_SQL, user.getGrantee().getUsername(), user.getPassword());
    }

    @Override
    public void grantAll(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (ShardingSphereUser each : users) {
                statement.execute(this.getGrantAllSQL(each));
            }
        }
    }

    private String getGrantAllSQL(ShardingSphereUser user) {
        return String.format(GRANT_ALL_SQL, user.getGrantee().getUsername());
    }

    @Override
    public Map<ShardingSphereUser, NativePrivileges> load(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        LinkedHashMap<ShardingSphereUser, NativePrivileges> result = new LinkedHashMap<ShardingSphereUser, NativePrivileges>();
        users.forEach(each -> result.put((ShardingSphereUser)each, new NativePrivileges()));
        this.fillTablePrivileges(result, dataSource, users);
        this.fillRolePrivileges(result, dataSource, users);
        return result;
    }

    private void fillTablePrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        HashMap<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> privilegeCache = new HashMap<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>>();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getTablePrivilegesSQL(users));){
            while (resultSet.next()) {
                this.collectPrivileges(privilegeCache, resultSet);
            }
        }
        this.fillTablePrivileges(privilegeCache, userPrivilegeMap);
    }

    private void fillTablePrivileges(Map<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> privilegeCache, Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap) {
        for (Map.Entry<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> entry : privilegeCache.entrySet()) {
            for (String db : entry.getValue().keySet()) {
                for (String tableName : entry.getValue().get(db).keySet()) {
                    TablePrivileges tablePrivileges = new TablePrivileges(tableName, (Collection<PrivilegeType>)entry.getValue().get(db).get(tableName));
                    NativePrivileges privileges = userPrivilegeMap.get(entry.getKey());
                    if (!privileges.getDatabasePrivileges().getSpecificPrivileges().containsKey(db)) {
                        privileges.getDatabasePrivileges().getSpecificPrivileges().put(db, new SchemaPrivileges(db));
                    }
                    privileges.getDatabasePrivileges().getSpecificPrivileges().get(db).getSpecificPrivileges().put(tableName, tablePrivileges);
                }
            }
        }
    }

    private void collectPrivileges(Map<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> privilegeCache, ResultSet resultSet) throws SQLException {
        String db = resultSet.getString("table_catalog");
        String tableName = resultSet.getString("table_name");
        String privilegeType = resultSet.getString("privilege_type");
        boolean hasPrivilege = Boolean.TRUE.toString().equalsIgnoreCase(resultSet.getString("is_grantable"));
        String grantee = resultSet.getString("grantee");
        if (hasPrivilege) {
            privilegeCache.computeIfAbsent(new ShardingSphereUser(grantee, "", ""), k -> new HashMap()).computeIfAbsent(db, k -> new HashMap()).computeIfAbsent(tableName, k -> new ArrayList()).add(this.getPrivilegeType(privilegeType));
        }
    }

    private void fillRolePrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getRolePrivilegesSQL(users));){
            while (resultSet.next()) {
                this.fillRolePrivileges(userPrivilegeMap, resultSet);
            }
        }
    }

    private void fillRolePrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, ResultSet resultSet) throws SQLException {
        Optional<ShardingSphereUser> user = this.findShardingSphereUser(userPrivilegeMap, resultSet);
        if (user.isPresent()) {
            userPrivilegeMap.get(user.get()).getAdministrativePrivileges().getPrivileges().addAll(this.loadRolePrivileges(resultSet));
        }
    }

    private Optional<ShardingSphereUser> findShardingSphereUser(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, ResultSet resultSet) throws SQLException {
        Grantee grantee = new Grantee(resultSet.getString("rolname"), "");
        return userPrivilegeMap.keySet().stream().filter(each -> each.getGrantee().equals((Object)grantee)).findFirst();
    }

    private Collection<PrivilegeType> loadRolePrivileges(ResultSet resultSet) throws SQLException {
        LinkedList<PrivilegeType> result = new LinkedList<PrivilegeType>();
        this.addToPrivilegeTypesIfPresent(resultSet.getBoolean("rolsuper"), PrivilegeType.SUPER, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getBoolean("rolcreaterole"), PrivilegeType.CREATE_ROLE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getBoolean("rolcreatedb"), PrivilegeType.CREATE_DATABASE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getBoolean("rolreplication"), PrivilegeType.REPL_CLIENT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getBoolean("rolinherit"), PrivilegeType.INHERIT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getBoolean("rolcanlogin"), PrivilegeType.CAN_LOGIN, result);
        return result;
    }

    private String getTablePrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userList = users.stream().map(each -> String.format("'%s'", each.getGrantee().getUsername())).collect(Collectors.joining(", "));
        return String.format(TABLE_PRIVILEGE_SQL, userList);
    }

    private String getRolePrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userList = users.stream().map(each -> String.format("'%s'", each.getGrantee().getUsername())).collect(Collectors.joining(", "));
        return String.format(ROLES_SQL, userList);
    }

    private PrivilegeType getPrivilegeType(String privilege) {
        switch (privilege) {
            case "SELECT": {
                return PrivilegeType.SELECT;
            }
            case "INSERT": {
                return PrivilegeType.INSERT;
            }
            case "UPDATE": {
                return PrivilegeType.UPDATE;
            }
            case "DELETE": {
                return PrivilegeType.DELETE;
            }
            case "TRUNCATE": {
                return PrivilegeType.TRUNCATE;
            }
            case "REFERENCES": {
                return PrivilegeType.REFERENCES;
            }
            case "TRIGGER": {
                return PrivilegeType.TRIGGER;
            }
            case "CREATE": {
                return PrivilegeType.CREATE;
            }
            case "EXECUTE": {
                return PrivilegeType.EXECUTE;
            }
            case "USAGE": {
                return PrivilegeType.USAGE;
            }
            case "CONNECT": {
                return PrivilegeType.CONNECT;
            }
            case "TEMPORARY": {
                return PrivilegeType.TEMPORARY;
            }
        }
        throw new UnsupportedOperationException(privilege);
    }

    private void addToPrivilegeTypesIfPresent(boolean hasPrivilege, PrivilegeType privilegeType, Collection<PrivilegeType> target) {
        if (hasPrivilege) {
            target.add(privilegeType);
        }
    }

    public String getType() {
        return "PostgreSQL";
    }
}

