/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.builder.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.provider.natived.builder.StoragePrivilegeHandler;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.NativePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.SchemaPrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.TablePrivileges;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class OraclePrivilegeHandler
implements StoragePrivilegeHandler {
    private static final String CREATE_USER_SQL = "CREATE USER %s IDENTIFIED BY %s";
    private static final String GRANT_ALL_SQL = "GRANT ALL PRIVILEGES TO %s";
    private static final String SYS_PRIVILEGE_SQL = "SELECT * FROM DBA_SYS_PRIVS WHERE GRANTEE IN (%s)";
    private static final String TABLE_PRIVILEGE_SQL = "SELECT GRANTEE, TABLE_SCHEMA, TABLE_NAME, PRIVILEGE, GRANTABLE, INHERITED FROM ALL_TAB_PRIVS WHERE GRANTEE IN (%s)";

    @Override
    public Collection<ShardingSphereUser> diff(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        LinkedList<Grantee> grantees = new LinkedList<Grantee>();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getSysPrivilegesSQL(users));){
            while (resultSet.next()) {
                grantees.add(new Grantee(resultSet.getString("GRANTEE"), ""));
            }
        }
        return users.stream().filter(each -> !grantees.contains(each.getGrantee())).collect(Collectors.toList());
    }

    @Override
    public void create(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (ShardingSphereUser each : users) {
                statement.execute(String.format(CREATE_USER_SQL, each.getGrantee().getUsername(), each.getPassword()));
            }
        }
    }

    @Override
    public void grantAll(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (ShardingSphereUser each : users) {
                statement.execute(String.format(GRANT_ALL_SQL, each.getGrantee().getUsername()));
            }
        }
    }

    @Override
    public Map<ShardingSphereUser, NativePrivileges> load(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        LinkedHashMap<ShardingSphereUser, NativePrivileges> result = new LinkedHashMap<ShardingSphereUser, NativePrivileges>();
        users.forEach(each -> result.put((ShardingSphereUser)each, new NativePrivileges()));
        this.fillSysPrivileges(result, dataSource, users);
        this.fillTablePrivileges(result, dataSource, users);
        return result;
    }

    private void fillTablePrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        HashMap<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> privilegeCache = new HashMap<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>>();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getTablePrivilegesSQL(users));){
            while (resultSet.next()) {
                this.collectTablePrivileges(privilegeCache, resultSet);
            }
        }
        this.fillTablePrivileges(privilegeCache, userPrivilegeMap);
    }

    private void fillTablePrivileges(Map<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> privilegeCache, Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap) {
        for (Map.Entry<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> entry : privilegeCache.entrySet()) {
            for (String db : entry.getValue().keySet()) {
                for (String tableName : entry.getValue().get(db).keySet()) {
                    TablePrivileges tablePrivileges = new TablePrivileges(tableName, (Collection<PrivilegeType>)entry.getValue().get(db).get(tableName));
                    NativePrivileges privileges = userPrivilegeMap.get(entry.getKey());
                    if (!privileges.getDatabasePrivileges().getSpecificPrivileges().containsKey(db)) {
                        privileges.getDatabasePrivileges().getSpecificPrivileges().put(db, new SchemaPrivileges(db));
                    }
                    privileges.getDatabasePrivileges().getSpecificPrivileges().get(db).getSpecificPrivileges().put(tableName, tablePrivileges);
                }
            }
        }
    }

    private void collectTablePrivileges(Map<ShardingSphereUser, Map<String, Map<String, List<PrivilegeType>>>> privilegeCache, ResultSet resultSet) throws SQLException {
        String db = resultSet.getString("TABLE_SCHEMA");
        String tableName = resultSet.getString("TABLE_NAME");
        String privilegeType = resultSet.getString("PRIVILEGE");
        boolean hasPrivilege = "YES".equalsIgnoreCase(resultSet.getString("GRANTABLE"));
        String grantee = resultSet.getString("GRANTEE");
        if (hasPrivilege) {
            privilegeCache.computeIfAbsent(new ShardingSphereUser(grantee, "", ""), k -> new HashMap()).computeIfAbsent(db, k -> new HashMap()).computeIfAbsent(tableName, k -> new ArrayList()).add(this.getPrivilegeType(privilegeType));
        }
    }

    private void fillSysPrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        HashMap<ShardingSphereUser, List<PrivilegeType>> privilegeCache = new HashMap<ShardingSphereUser, List<PrivilegeType>>();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getSysPrivilegesSQL(users));){
            while (resultSet.next()) {
                this.collectSysPrivileges(privilegeCache, resultSet);
            }
        }
        this.fillSysPrivileges(privilegeCache, userPrivilegeMap);
    }

    private void fillSysPrivileges(Map<ShardingSphereUser, List<PrivilegeType>> privilegeCache, Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap) {
        for (Map.Entry<ShardingSphereUser, List<PrivilegeType>> entry : privilegeCache.entrySet()) {
            userPrivilegeMap.get(entry.getKey()).getAdministrativePrivileges().getPrivileges().addAll((Collection<PrivilegeType>)entry.getValue());
        }
    }

    private void collectSysPrivileges(Map<ShardingSphereUser, List<PrivilegeType>> privilegeCache, ResultSet resultSet) throws SQLException {
        String privilegeType = resultSet.getString("PRIVILEGE");
        String grantee = resultSet.getString("GRANTEE");
        privilegeCache.computeIfAbsent(new ShardingSphereUser(grantee, "", ""), k -> new ArrayList()).add(this.getPrivilegeType(privilegeType));
    }

    private Optional<ShardingSphereUser> findShardingSphereUser(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, ResultSet resultSet) throws SQLException {
        Grantee grantee = new Grantee(resultSet.getString("rolname"), "");
        return userPrivilegeMap.keySet().stream().filter(each -> each.getGrantee().equals((Object)grantee)).findFirst();
    }

    private String getSysPrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userList = users.stream().map(each -> String.format("'%s'", each.getGrantee().getUsername())).collect(Collectors.joining(", "));
        return String.format(SYS_PRIVILEGE_SQL, userList);
    }

    private String getTablePrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userList = users.stream().map(each -> String.format("'%s'", each.getGrantee().getUsername())).collect(Collectors.joining(", "));
        return String.format(TABLE_PRIVILEGE_SQL, userList);
    }

    private PrivilegeType getPrivilegeType(String privilege) {
        switch (privilege) {
            case "SELECT": {
                return PrivilegeType.SELECT;
            }
            case "INSERT": {
                return PrivilegeType.INSERT;
            }
            case "UPDATE": {
                return PrivilegeType.UPDATE;
            }
            case "DELETE": {
                return PrivilegeType.DELETE;
            }
            case "REFERENCES": {
                return PrivilegeType.REFERENCES;
            }
            case "INDEX": {
                return PrivilegeType.INDEX;
            }
            case "EXECUTE": {
                return PrivilegeType.EXECUTE;
            }
            case "CREATE PROCEDURE": {
                return PrivilegeType.CREATE_PROC;
            }
            case "CREATE ROLE": {
                return PrivilegeType.CREATE_ROLE;
            }
            case "CREATE SEQUENCE": {
                return PrivilegeType.CREATE_SEQUENCE;
            }
            case "CREATE TABLESPACE": {
                return PrivilegeType.CREATE_TABLESPACE;
            }
            case "CREATE USER": {
                return PrivilegeType.CREATE_USER;
            }
            case "CREATE VIEW": {
                return PrivilegeType.CREATE_VIEW;
            }
            case "SYSDBA": {
                return PrivilegeType.SUPER;
            }
        }
        throw new UnsupportedOperationException(privilege);
    }

    public String getType() {
        return "Oracle";
    }
}

