/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.builder.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.provider.natived.builder.StoragePrivilegeHandler;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.NativePrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.SchemaPrivileges;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.TablePrivileges;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class MySQLPrivilegeHandler
implements StoragePrivilegeHandler {
    private static final String CREATE_USER_SQL = "CREATE USER %s";
    private static final String GRANT_ALL_SQL = "GRANT ALL ON *.* TO %s";
    private static final String GLOBAL_PRIVILEGE_SQL = "SELECT * FROM mysql.user WHERE (user, host) in (%s)";
    private static final String SCHEMA_PRIVILEGE_SQL = "SELECT * FROM mysql.db WHERE (user, host) in (%s)";
    private static final String TABLE_PRIVILEGE_SQL = "SELECT Db, Table_name, Table_priv FROM mysql.tables_priv WHERE (user, host) in (%s)";

    @Override
    public Collection<ShardingSphereUser> diff(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        LinkedList<Grantee> grantees = new LinkedList<Grantee>();
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getGlobalPrivilegesSQL(users));){
            while (resultSet.next()) {
                grantees.add(new Grantee(resultSet.getString("user"), resultSet.getString("host")));
            }
        }
        return users.stream().filter(each -> !grantees.contains(each.getGrantee())).collect(Collectors.toList());
    }

    @Override
    public void create(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(this.getCreateUsersSQL(users));
        }
    }

    private String getCreateUsersSQL(Collection<ShardingSphereUser> users) {
        String createUsers = users.stream().map(each -> String.format("'%s'@'%s' IDENTIFIED BY '%s'", each.getGrantee().getUsername(), each.getGrantee().getHostname(), each.getPassword())).collect(Collectors.joining(", "));
        return String.format(CREATE_USER_SQL, createUsers);
    }

    @Override
    public void grantAll(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(this.getGrantAllSQL(users));
        }
    }

    private String getGrantAllSQL(Collection<ShardingSphereUser> users) {
        String grantUsers = users.stream().map(each -> String.format("'%s'@'%s'", each.getGrantee().getUsername(), each.getGrantee().getHostname())).collect(Collectors.joining(", "));
        return String.format(GRANT_ALL_SQL, grantUsers);
    }

    @Override
    public Map<ShardingSphereUser, NativePrivileges> load(Collection<ShardingSphereUser> users, DataSource dataSource) throws SQLException {
        LinkedHashMap<ShardingSphereUser, NativePrivileges> result = new LinkedHashMap<ShardingSphereUser, NativePrivileges>();
        users.forEach(each -> result.put((ShardingSphereUser)each, new NativePrivileges()));
        this.fillGlobalPrivileges(result, dataSource, users);
        this.fillSchemaPrivileges(result, dataSource, users);
        this.fillTablePrivileges(result, dataSource, users);
        return result;
    }

    private void fillGlobalPrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getGlobalPrivilegesSQL(users));){
            while (resultSet.next()) {
                this.fillGlobalPrivileges(userPrivilegeMap, resultSet);
            }
        }
    }

    private void fillGlobalPrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, ResultSet resultSet) throws SQLException {
        Optional<ShardingSphereUser> user = this.findShardingSphereUser(userPrivilegeMap, resultSet);
        if (user.isPresent()) {
            userPrivilegeMap.get(user.get()).getAdministrativePrivileges().getPrivileges().addAll(this.loadAdministrativePrivileges(resultSet));
            userPrivilegeMap.get(user.get()).getDatabasePrivileges().getGlobalPrivileges().addAll(this.loadDatabaseGlobalPrivileges(resultSet));
        }
    }

    private void fillSchemaPrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getSchemaPrivilegesSQL(users));){
            while (resultSet.next()) {
                this.fillSchemaPrivileges(userPrivilegeMap, resultSet);
            }
        }
    }

    private void fillSchemaPrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, ResultSet resultSet) throws SQLException {
        Optional<ShardingSphereUser> user = this.findShardingSphereUser(userPrivilegeMap, resultSet);
        if (user.isPresent()) {
            String db = resultSet.getString("Db");
            SchemaPrivileges schemaPrivileges = new SchemaPrivileges(db);
            schemaPrivileges.getGlobalPrivileges().addAll(this.loadDatabaseGlobalPrivileges(resultSet));
            userPrivilegeMap.get(user.get()).getDatabasePrivileges().getSpecificPrivileges().put(db, schemaPrivileges);
        }
    }

    private void fillTablePrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, DataSource dataSource, Collection<ShardingSphereUser> users) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.getTablePrivilegesSQL(users));){
            while (resultSet.next()) {
                this.fillTablePrivileges(userPrivilegeMap, resultSet);
            }
        }
    }

    private void fillTablePrivileges(Map<ShardingSphereUser, NativePrivileges> userPrivilegeMap, ResultSet resultSet) throws SQLException {
        Optional<ShardingSphereUser> user = this.findShardingSphereUser(userPrivilegeMap, resultSet);
        if (user.isPresent()) {
            String db = resultSet.getString("Db");
            String tableName = resultSet.getString("Table_name");
            TablePrivileges tablePrivileges = new TablePrivileges(tableName, this.getPrivileges((String[])resultSet.getArray("Table_priv").getArray()));
            NativePrivileges privileges = userPrivilegeMap.get(user.get());
            if (!privileges.getDatabasePrivileges().getSpecificPrivileges().containsKey(db)) {
                privileges.getDatabasePrivileges().getSpecificPrivileges().put(db, new SchemaPrivileges(db));
            }
            privileges.getDatabasePrivileges().getSpecificPrivileges().get(db).getSpecificPrivileges().put(tableName, tablePrivileges);
        }
    }

    private String getGlobalPrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userHostTuples = users.stream().map(each -> String.format("('%s', '%s')", each.getGrantee().getUsername(), each.getGrantee().getHostname())).collect(Collectors.joining(", "));
        return String.format(GLOBAL_PRIVILEGE_SQL, userHostTuples);
    }

    private String getSchemaPrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userHostTuples = users.stream().map(each -> String.format("('%s', '%s')", each.getGrantee().getUsername(), each.getGrantee().getHostname())).collect(Collectors.joining(", "));
        return String.format(SCHEMA_PRIVILEGE_SQL, userHostTuples);
    }

    private String getTablePrivilegesSQL(Collection<ShardingSphereUser> users) {
        String userHostTuples = users.stream().map(each -> String.format("('%s', '%s')", each.getGrantee().getUsername(), each.getGrantee().getHostname())).collect(Collectors.joining(", "));
        return String.format(TABLE_PRIVILEGE_SQL, userHostTuples);
    }

    private Optional<ShardingSphereUser> findShardingSphereUser(Map<ShardingSphereUser, NativePrivileges> privileges, ResultSet resultSet) throws SQLException {
        Grantee grantee = new Grantee(resultSet.getString("user"), resultSet.getString("host"));
        return privileges.keySet().stream().filter(each -> each.getGrantee().equals((Object)grantee)).findFirst();
    }

    private Collection<PrivilegeType> getPrivileges(String[] privileges) {
        return Arrays.stream(privileges).map(this::getPrivilegeType).collect(Collectors.toSet());
    }

    private PrivilegeType getPrivilegeType(String privilege) {
        switch (privilege) {
            case "Select": {
                return PrivilegeType.SELECT;
            }
            case "Insert": {
                return PrivilegeType.INSERT;
            }
            case "Update": {
                return PrivilegeType.UPDATE;
            }
            case "Delete": {
                return PrivilegeType.DELETE;
            }
            case "Create": {
                return PrivilegeType.CREATE;
            }
            case "Alter": {
                return PrivilegeType.ALTER;
            }
            case "Drop": {
                return PrivilegeType.DROP;
            }
            case "Grant": {
                return PrivilegeType.GRANT;
            }
            case "Index": {
                return PrivilegeType.INDEX;
            }
            case "References": {
                return PrivilegeType.REFERENCES;
            }
            case "Create View": {
                return PrivilegeType.CREATE_VIEW;
            }
            case "Show view": {
                return PrivilegeType.SHOW_VIEW;
            }
            case "Trigger": {
                return PrivilegeType.TRIGGER;
            }
        }
        throw new UnsupportedOperationException(privilege);
    }

    private Collection<PrivilegeType> loadAdministrativePrivileges(ResultSet resultSet) throws SQLException {
        LinkedList<PrivilegeType> result = new LinkedList<PrivilegeType>();
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Super_priv"), PrivilegeType.SUPER, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Reload_priv"), PrivilegeType.RELOAD, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Shutdown_priv"), PrivilegeType.SHUTDOWN, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Process_priv"), PrivilegeType.PROCESS, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("File_priv"), PrivilegeType.FILE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Show_db_priv"), PrivilegeType.SHOW_DB, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Repl_slave_priv"), PrivilegeType.REPL_SLAVE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Repl_client_priv"), PrivilegeType.REPL_CLIENT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Create_user_priv"), PrivilegeType.CREATE_USER, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Create_tablespace_priv"), PrivilegeType.CREATE_TABLESPACE, result);
        return result;
    }

    private Collection<PrivilegeType> loadDatabaseGlobalPrivileges(ResultSet resultSet) throws SQLException {
        LinkedList<PrivilegeType> result = new LinkedList<PrivilegeType>();
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Select_priv"), PrivilegeType.SELECT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Insert_priv"), PrivilegeType.INSERT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Update_priv"), PrivilegeType.UPDATE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Delete_priv"), PrivilegeType.DELETE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Create_priv"), PrivilegeType.CREATE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Alter_priv"), PrivilegeType.ALTER, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Drop_priv"), PrivilegeType.DROP, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Grant_priv"), PrivilegeType.GRANT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Index_priv"), PrivilegeType.INDEX, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("References_priv"), PrivilegeType.REFERENCES, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Create_tmp_table_priv"), PrivilegeType.CREATE_TMP, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Lock_tables_priv"), PrivilegeType.LOCK_TABLES, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Execute_priv"), PrivilegeType.EXECUTE, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Create_view_priv"), PrivilegeType.CREATE_VIEW, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Show_view_priv"), PrivilegeType.SHOW_VIEW, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Create_routine_priv"), PrivilegeType.CREATE_PROC, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Alter_routine_priv"), PrivilegeType.ALTER_PROC, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Event_priv"), PrivilegeType.EVENT, result);
        this.addToPrivilegeTypesIfPresent(resultSet.getObject("Trigger_priv"), PrivilegeType.TRIGGER, result);
        return result;
    }

    private void addToPrivilegeTypesIfPresent(Object hasPrivilege, PrivilegeType privilegeType, Collection<PrivilegeType> target) {
        if ("Y".equals(hasPrivilege)) {
            target.add(privilegeType);
        }
        if (hasPrivilege instanceof Boolean && ((Boolean)hasPrivilege).booleanValue()) {
            target.add(privilegeType);
        }
    }

    public String getType() {
        return "MySQL";
    }
}

