/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.database.builder;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.provider.database.model.privilege.DatabasePermittedPrivileges;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class DatabasePrivilegeBuilder {
    public static Map<ShardingSphereUser, ShardingSpherePrivileges> build(Collection<ShardingSphereUser> users, Properties props) {
        String mappingProp = props.getProperty("user-database-mappings", "");
        DatabasePrivilegeBuilder.checkDatabases(mappingProp);
        return DatabasePrivilegeBuilder.buildPrivileges(users, mappingProp);
    }

    private static void checkDatabases(String mappingProp) {
        Preconditions.checkArgument((!"".equals(mappingProp) ? 1 : 0) != 0, (String)"user-database-mappings configuration `%s` can not be null", (Object)mappingProp);
        Arrays.stream(mappingProp.split(",")).forEach(each -> Preconditions.checkArgument((0 < each.indexOf("@") && 0 < each.indexOf("=") ? 1 : 0) != 0, (String)"user-database-mappings configuration `%s` is invalid, the configuration format should be like `username@hostname=database`", (Object)each));
    }

    private static Map<ShardingSphereUser, ShardingSpherePrivileges> buildPrivileges(Collection<ShardingSphereUser> users, String mappingProp) {
        Map<ShardingSphereUser, Collection<String>> userDatabaseMappings = DatabasePrivilegeBuilder.convertDatabases(mappingProp);
        HashMap<ShardingSphereUser, ShardingSpherePrivileges> result = new HashMap<ShardingSphereUser, ShardingSpherePrivileges>(users.size(), 1.0f);
        users.forEach(each -> result.put((ShardingSphereUser)each, new DatabasePermittedPrivileges(new HashSet<String>(DatabasePrivilegeBuilder.getUserDatabases(each, userDatabaseMappings)))));
        return result;
    }

    private static Map<ShardingSphereUser, Collection<String>> convertDatabases(String mappingProp) {
        String[] mappings = mappingProp.split(",");
        HashMap<ShardingSphereUser, Collection<String>> result = new HashMap<ShardingSphereUser, Collection<String>>(mappings.length, 1.0f);
        Arrays.asList(mappings).forEach(each -> {
            String[] userDatabasePair = each.trim().split("=");
            String yamlUser = userDatabasePair[0];
            String username = yamlUser.substring(0, yamlUser.indexOf("@"));
            String hostname = yamlUser.substring(yamlUser.indexOf("@") + 1);
            ShardingSphereUser shardingSphereUser = new ShardingSphereUser(username, "", hostname);
            Collection databases = result.getOrDefault(shardingSphereUser, new HashSet());
            databases.add(userDatabasePair[1]);
            result.putIfAbsent(shardingSphereUser, databases);
        });
        return result;
    }

    private static Collection<String> getUserDatabases(ShardingSphereUser shardingSphereUser, Map<ShardingSphereUser, Collection<String>> userDatabaseMappings) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<ShardingSphereUser, Collection<String>> entry : userDatabaseMappings.entrySet()) {
            boolean isAnyOtherHost = DatabasePrivilegeBuilder.checkAnyOtherHost(entry.getKey().getGrantee(), shardingSphereUser);
            if (!isAnyOtherHost && shardingSphereUser != entry.getKey() && !shardingSphereUser.equals((Object)entry.getKey())) continue;
            result.addAll(entry.getValue());
        }
        return result;
    }

    private static boolean checkAnyOtherHost(Grantee grantee, ShardingSphereUser shardingSphereUser) {
        return ("%".equalsIgnoreCase(grantee.getHostname()) || grantee.getHostname().equals(shardingSphereUser.getGrantee().getHostname())) && grantee.getUsername().equals(shardingSphereUser.getGrantee().getUsername());
    }

    @Generated
    private DatabasePrivilegeBuilder() {
    }
}

