/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.trigger;

import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.trigger.TriggerNode;
import org.apache.shardingsphere.elasticjob.lite.internal.trigger.TriggerService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class TriggerListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final TriggerNode triggerNode;
    private final TriggerService triggerService;

    public TriggerListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.triggerNode = new TriggerNode(jobName);
        this.triggerService = new TriggerService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobTriggerStatusJobListener());
    }

    class JobTriggerStatusJobListener
    extends AbstractJobListener {
        JobTriggerStatusJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (!TriggerListenerManager.this.triggerNode.isLocalTriggerPath(path) || CuratorCacheListener.Type.NODE_CREATED != eventType) {
                return;
            }
            TriggerListenerManager.this.triggerService.removeTriggerFlag();
            if (!JobRegistry.getInstance().isShutdown(TriggerListenerManager.this.jobName) && !JobRegistry.getInstance().isJobRunning(TriggerListenerManager.this.jobName)) {
                JobRegistry.getInstance().getJobScheduleController(TriggerListenerManager.this.jobName).triggerJob();
            }
        }
    }
}

