/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;

@Activate
public class TokenHeaderFilter
implements HeaderFilter {
    @Override
    public RpcInvocation invoke(Invoker<?> invoker, RpcInvocation invocation) throws RpcException {
        String token = invoker.getUrl().getParameter("token");
        if (ConfigUtils.isNotEmpty(token)) {
            String remoteToken;
            Class<?> serviceType = invoker.getInterface();
            Map<String, Object> attachments = invocation.getObjectAttachments();
            String string = remoteToken = attachments == null ? null : (String)attachments.get("token");
            if (!token.equals(remoteToken)) {
                throw new RpcException(4, "Forbid invoke remote service " + serviceType + " method " + invocation.getMethodName() + "() from consumer " + RpcContext.getServiceContext().getRemoteHost() + " to provider " + RpcContext.getServiceContext().getLocalHost() + ", consumer incorrect token is " + remoteToken);
            }
        }
        return invocation;
    }
}

