/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.support;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public abstract class AbstractRegistryFactory
implements RegistryFactory,
ScopeModelAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegistryFactory.class);
    private RegistryManager registryManager;
    protected ApplicationModel applicationModel;

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.registryManager = applicationModel.getBeanFactory().getBean(RegistryManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registry getRegistry(URL url) {
        if (this.registryManager == null) {
            throw new IllegalStateException("Unable to fetch RegistryManager from ApplicationModel BeanFactory. Please check if `setApplicationModel` has been override.");
        }
        Registry defaultNopRegistry = this.registryManager.getDefaultNopRegistryIfDestroyed();
        if (null != defaultNopRegistry) {
            return defaultNopRegistry;
        }
        url = URLBuilder.from(url).setPath(RegistryService.class.getName()).addParameter("interface", RegistryService.class.getName()).removeParameter("timestamp").removeAttribute("export").removeAttribute("refer").build();
        String key = this.createRegistryCacheKey(url);
        Registry registry = null;
        boolean check = url.getParameter("check", true) && url.getPort() != 0;
        this.registryManager.getRegistryLock().lock();
        try {
            defaultNopRegistry = this.registryManager.getDefaultNopRegistryIfDestroyed();
            if (null != defaultNopRegistry) {
                Registry registry2 = defaultNopRegistry;
                return registry2;
            }
            registry = this.registryManager.getRegistry(key);
            if (registry != null) {
                Registry registry3 = registry;
                return registry3;
            }
            registry = this.createRegistry(url);
        }
        catch (Exception e) {
            if (check) {
                throw new RuntimeException("Can not create registry " + url, e);
            }
            LOGGER.warn("Failed to obtain or create registry ", e);
        }
        finally {
            this.registryManager.getRegistryLock().unlock();
        }
        if (check && registry == null) {
            throw new IllegalStateException("Can not create registry " + url);
        }
        if (registry != null) {
            this.registryManager.putRegistry(key, registry);
        }
        return registry;
    }

    protected String createRegistryCacheKey(URL url) {
        return url.toServiceStringWithoutResolving();
    }

    protected abstract Registry createRegistry(URL var1);
}

