/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Compare {
    NONE(-1, null, null, null){

        @Override
        public boolean compare(Object value, Object target) {
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    AUTO(0, null, null, null){

        @Override
        public boolean compare(Object value, Object target) {
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    EQUAL(10, "\u7b49\u4e8e", "eq", " = ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target) {
                return null == value;
            }
            return target.toString().equalsIgnoreCase(value.toString());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    EQUALS(11, "\u7b49\u4e8e", "eq", " == ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target) {
                return null == value;
            }
            return target.toString().equalsIgnoreCase(value.toString());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    GREAT(20, "\u5927\u4e8e", "gt", " > ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) > 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    GREAT_EQUAL(21, "\u5927\u4e8e\u7b49\u4e8e", "gte", " >= ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) >= 0;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    LESS(30, "\u5c0f\u4e8e", "lt", " < ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) < 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    LESS_EQUAL(31, "\u5c0f\u4e8e\u7b49\u4e8e", "lte", " <= ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) <= 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    IN(40, "in", "in", " IN "){

        @Override
        public boolean compare(Object value, Object targets) {
            if (null != targets && targets instanceof Collection) {
                Collection cols = (Collection)targets;
                for (Object v : cols) {
                    if (null == v || !v.toString().equalsIgnoreCase(value.toString())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    LIKE(50, "like %?%", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().contains(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    LIKE_PREFIX(51, "like ?%", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().startsWith(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    START_WITH(51, "like ?%", "", " LIKE "){

        @Override
        public int getCode() {
            return 51;
        }

        @Override
        public String formula() {
            return " LIKE ";
        }

        @Override
        public String getName() {
            return "like ?%";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().startsWith(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    LIKE_SUFFIX(52, "like %?", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    END_WITH(52, "like %?", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    MATCH(55, "MATCH", "", " "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    MATCH_PHRASE(56, "MATCH_PHRASE", "", " "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    LIKES(59, "like %?%", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().contains(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    FIND_IN_SET(60, "find in set", "", " FIND_IN_SET "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            String[] arrays = target.toString().split(",");
            return BeanUtil.array2list(new String[][]{arrays}).contains(value);
        }

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    FIND_IN_SET_OR(61, "find in set", "", " FIND_IN_SET "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            String[] arrays = target.toString().split(",");
            return BeanUtil.array2list(new String[][]{arrays}).contains(value);
        }

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    FIND_IN_SET_AND(62, "find in set", "", " FIND_IN_SET "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            String[] arrays = target.toString().split(",");
            return BeanUtil.array2list(new String[][]{arrays}).contains(value);
        }

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    JSON_CONTAINS(71, "json_contains", "", " JSON_CONTAINS "){

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    JSON_CONTAINS_PATH_OR(75, "json_contains_path", "", " JSON_CONTAINS_PATH "){

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    JSON_CONTAINS_PATH_ONE(75, "json_contains_path", "", " JSON_CONTAINS_PATH "){

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    JSON_CONTAINS_PATH_AND(76, "json_contains_path", "", " JSON_CONTAINS_PATH "){

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    JSON_CONTAINS_PATH_ALL(76, "json_contains_path", "", " JSON_CONTAINS_PATH "){

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    BETWEEN(80, "\u533a\u95f4", "", " BETWEEN ? AND ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == value) {
                return false;
            }
            if (target instanceof List) {
                List list = (List)target;
                Object min = list.get(0);
                Object max = list.get(1);
                return this.compare(value, BasicUtil.parseDecimal(min, null), BasicUtil.parseDecimal(max, null));
            }
            return false;
        }

        public boolean compare(Object value, BigDecimal min, BigDecimal max) {
            if (null == value || null == min || null == max) {
                return false;
            }
            try {
                BigDecimal v = new BigDecimal(value.toString());
                if (v.compareTo(min) >= 0 && v.compareTo(max) <= 0) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 2;
        }
    }
    ,
    NULL(90, "\u7a7a", "", " IS NULL "){

        @Override
        public boolean compare(Object value, Object target) {
            return null == value;
        }

        @Override
        public int valueCount() {
            return 0;
        }
    }
    ,
    EMPTY(91, "\u7a7a", "", " IS EMPTY "){

        @Override
        public boolean compare(Object value, Object target) {
            return BasicUtil.isEmpty(true, value);
        }

        @Override
        public int valueCount() {
            return 0;
        }
    }
    ,
    NOT_EQUAL(110, "\u4e0d\u7b49\u4e8e", "nin", " != ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return !value.toString().toUpperCase().equals(target.toString().toUpperCase());
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    NOT_IN(140, "\u4e0d\u5305\u542b", "nin", " NOT IN "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 9;
        }
    }
    ,
    NOT_LIKE(150, "NOT LIKE %?%", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    NOT_LIKE_PREFIX(151, "NOT LIKE ?%", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    NOT_START_WITH(151, "NOT LIKE ?%", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    NOT_LIKE_SUFFIX(152, "NOT LIKE %?", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    NOT_END_WITH(152, "NOT LIKE %?", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    }
    ,
    NOT_NULL(190, "\u975e\u7a7a", "", " IS NOT NULL "){

        @Override
        public boolean compare(Object value, Object target) {
            return null != value;
        }

        @Override
        public int valueCount() {
            return 0;
        }
    }
    ,
    NOT_EMPTY(191, "\u975e\u7a7a", "", " IS NOT EMPTY "){

        @Override
        public boolean compare(Object value, Object target) {
            return !BasicUtil.isEmpty(true, value);
        }

        @Override
        public int valueCount() {
            return 0;
        }
    }
    ,
    REGEX(999, "\u6b63\u5219", "regex", " REGEXP ?"){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public int valueCount() {
            return 1;
        }
    };

    private final int code;
    private final String operator;
    private final String formula;
    private final String name;

    public boolean compare(Object value) {
        return false;
    }

    public boolean compare(Object value, Object target) {
        return false;
    }

    public boolean compare(Object value, Object min, Object max) {
        return false;
    }

    private Compare(int code, String name, String operator, String formula) {
        this.code = code;
        this.name = name;
        this.formula = formula;
        this.operator = operator;
    }

    public abstract int valueCount();

    public String formula() {
        return this.formula;
    }

    public String formula(String column, Object value, boolean placeholder) {
        if (!placeholder) {
            String str = "";
            if (null != value) {
                str = value.toString();
            }
            return this.formula.replace("?", str);
        }
        return this.formula;
    }

    public String getOperator() {
        return this.operator;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static enum EMPTY_VALUE_SWITCH {
        IGNORE,
        BREAK,
        NULL,
        SRC,
        NONE;

    }
}

