/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake.machine.k8s;

import com.google.common.base.Preconditions;
import java.time.Duration;
import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.machine.AbstractMachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.InstanceId;
import me.ahoo.cosid.snowflake.machine.MachineState;
import me.ahoo.cosid.snowflake.machine.MachineStateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulSetMachineIdDistributor
extends AbstractMachineIdDistributor {
    private static final Logger log = LoggerFactory.getLogger(StatefulSetMachineIdDistributor.class);
    public static final StatefulSetMachineIdDistributor INSTANCE = new StatefulSetMachineIdDistributor(MachineStateStorage.LOCAL, ClockBackwardsSynchronizer.DEFAULT);
    public static final String HOSTNAME_KEY = "HOSTNAME";

    public StatefulSetMachineIdDistributor(MachineStateStorage machineStateStorage, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        super(machineStateStorage, clockBackwardsSynchronizer);
    }

    public static int resolveMachineId() {
        String hostName = System.getenv(HOSTNAME_KEY);
        Preconditions.checkNotNull((Object)hostName, (Object)"HOSTNAME can not be null.");
        int lastSplitIdx = hostName.lastIndexOf("-");
        Preconditions.checkArgument((lastSplitIdx > 0 ? 1 : 0) != 0, (String)"The format of hostName:[%s] is incorrect.", (Object)hostName);
        String idStr = hostName.substring(lastSplitIdx + 1);
        if (log.isInfoEnabled()) {
            log.info("resolveMachineId - machineId:[{}] from Env HOSTNAME:[{}]", (Object)idStr, (Object)hostName);
        }
        return Integer.parseInt(idStr);
    }

    @Override
    protected MachineState distributeRemote(String namespace, int machineBit, InstanceId instanceId, Duration safeGuardDuration) {
        int machineId = StatefulSetMachineIdDistributor.resolveMachineId();
        MachineState machineState = MachineState.of(machineId, -1L);
        if (log.isInfoEnabled()) {
            log.info("distribute0 - machineState:[{}] - instanceId:[{}] - machineBit:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, machineBit, namespace});
        }
        return machineState;
    }

    @Override
    protected void revertRemote(String namespace, InstanceId instanceId, MachineState machineState) {
    }

    @Override
    protected void guardRemote(String namespace, InstanceId instanceId, MachineState machineState, Duration safeGuardDuration) {
    }
}

