/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake.machine;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.snowflake.machine.InstanceId;
import me.ahoo.cosid.snowflake.machine.MachineState;
import me.ahoo.cosid.snowflake.machine.MachineStateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMachineStateStorage
implements MachineStateStorage {
    private static final Logger log = LoggerFactory.getLogger(LocalMachineStateStorage.class);
    public static final String DEFAULT_STATE_LOCATION_PATH = "./cosid-machine-state/";
    public final String stateLocation;

    public LocalMachineStateStorage(String stateLocation) {
        this.stateLocation = stateLocation;
    }

    public LocalMachineStateStorage() {
        this(DEFAULT_STATE_LOCATION_PATH);
    }

    @Override
    public MachineState get(String namespace, InstanceId instanceId) {
        String stateString;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        if (log.isDebugEnabled()) {
            log.debug("get - read from stateLocation : [{}].", (Object)stateFile.getAbsolutePath());
        }
        if (!stateFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info("get - read from stateLocation : [{}] not found.", (Object)stateFile.getAbsolutePath());
            }
            return MachineState.NOT_FOUND;
        }
        try {
            stateString = Files.asCharSource((File)stateFile, (Charset)Charsets.UTF_8).readFirstLine();
        }
        catch (IOException e) {
            throw new CosIdException(e);
        }
        if (Strings.isNullOrEmpty((String)stateString)) {
            if (log.isWarnEnabled()) {
                log.warn("get - read from stateLocation : [{}] state data is empty.", (Object)stateFile.getAbsolutePath());
            }
            return MachineState.NOT_FOUND;
        }
        if (log.isDebugEnabled()) {
            log.debug("get - state data : [{}].", (Object)stateString);
        }
        return MachineState.of(stateString);
    }

    private File getStateFile(String namespace, InstanceId instanceId) {
        File stateDirectory = new File(this.stateLocation);
        if (!stateDirectory.exists()) {
            boolean bl = stateDirectory.mkdirs();
        }
        String statePath = this.stateLocation + namespace + "__" + instanceId.getInstanceId();
        return new File(statePath);
    }

    @Override
    public void set(String namespace, int machineId, InstanceId instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((machineId >= 0 ? 1 : 0) != 0, (String)"machineId:[%s] must be greater than or equal to 0!", (int)machineId);
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        if (log.isDebugEnabled()) {
            log.debug("set - write machineId:[{}] to stateLocation : [{}].", (Object)machineId, (Object)stateFile.getAbsolutePath());
        }
        String stateString = MachineState.of(machineId, System.currentTimeMillis()).toStateString();
        if (!stateFile.exists()) {
            try {
                boolean bl = stateFile.createNewFile();
            }
            catch (IOException e) {
                throw new CosIdException(e);
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(stateFile, false);){
            fileOutputStream.write(stateString.getBytes(Charsets.UTF_8));
            fileOutputStream.flush();
        }
        catch (IOException e) {
            throw new CosIdException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(String namespace, InstanceId instanceId) {
        boolean isDeleted;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        if (log.isInfoEnabled()) {
            log.info("remove - stateLocation : [{}].", (Object)stateFile.getAbsolutePath());
        }
        if (stateFile.exists() && !(isDeleted = stateFile.delete())) {
            log.warn("remove and delete instance :[{}] stateFile in namespace[{}] not successful! FilePath:[{}]", new Object[]{instanceId, namespace, stateFile.getAbsolutePath()});
        }
    }

    @Override
    public void clear(String namespace) {
        File[] stateFiles;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        if (log.isInfoEnabled()) {
            log.info("clear - namespace : [{}].", (Object)namespace);
        }
        if ((stateFiles = this.getStateFilesOf(namespace)) == null) {
            return;
        }
        for (File stateFile : stateFiles) {
            if (log.isInfoEnabled()) {
                log.info("clear - stateLocation : [{}].", (Object)stateFile.getAbsolutePath());
            }
            boolean bl = stateFile.delete();
        }
    }

    private File[] getStateFilesOf(String namespace) {
        File stateDirectory = new File(this.stateLocation);
        if (!stateDirectory.exists()) {
            return new File[0];
        }
        return stateDirectory.listFiles((dir, name) -> name.startsWith(namespace));
    }

    @Override
    public int size(String namespace) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        return this.getStateFilesOf(namespace).length;
    }

    @Override
    public boolean exists(String namespace, InstanceId instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        File stateFile = this.getStateFile(namespace, instanceId);
        return stateFile.exists();
    }
}

