/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake.machine;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.ahoo.cosid.snowflake.machine.InstanceId;
import me.ahoo.cosid.snowflake.machine.MachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.MachineIdGuarder;
import me.ahoo.cosid.snowflake.machine.NamespacedInstanceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMachineIdGuarder
implements MachineIdGuarder {
    private static final Logger log = LoggerFactory.getLogger(DefaultMachineIdGuarder.class);
    public static final Duration DEFAULT_INITIAL_DELAY = Duration.ofMinutes(1L);
    public static final Duration DEFAULT_DELAY = Duration.ofMinutes(1L);
    private final CopyOnWriteArraySet<NamespacedInstanceId> registeredInstanceIds;
    private final MachineIdDistributor machineIdDistributor;
    private final ScheduledExecutorService executorService;
    private final Duration initialDelay;
    private final Duration delay;
    private final Duration safeGuardDuration;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public DefaultMachineIdGuarder(MachineIdDistributor machineIdDistributor, Duration safeGuardDuration) {
        this(machineIdDistributor, DefaultMachineIdGuarder.executorService(), DEFAULT_INITIAL_DELAY, DEFAULT_DELAY, safeGuardDuration);
    }

    public DefaultMachineIdGuarder(MachineIdDistributor machineIdDistributor, ScheduledExecutorService executorService, Duration initialDelay, Duration delay, Duration safeGuardDuration) {
        this.registeredInstanceIds = new CopyOnWriteArraySet();
        this.machineIdDistributor = machineIdDistributor;
        this.executorService = executorService;
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.safeGuardDuration = safeGuardDuration;
    }

    public static ScheduledExecutorService executorService() {
        return new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DefaultMachineIdGuarder-").build());
    }

    @Override
    public void register(String namespace, InstanceId instanceId) {
        this.registeredInstanceIds.add(new NamespacedInstanceId(namespace, instanceId));
    }

    @Override
    public void unregister(String namespace, InstanceId instanceId) {
        this.registeredInstanceIds.remove(new NamespacedInstanceId(namespace, instanceId));
    }

    public CopyOnWriteArraySet<NamespacedInstanceId> getRegisteredInstanceIds() {
        return this.registeredInstanceIds;
    }

    @Override
    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("start - registeredInstances:[{}].", (Object)this.registeredInstanceIds.size());
        }
        if (this.running.compareAndSet(false, true)) {
            this.scheduledFuture = this.executorService.scheduleWithFixedDelay(this::safeGuard, this.initialDelay.toMillis(), this.delay.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void safeGuard() {
        if (log.isDebugEnabled()) {
            log.debug("safeGuard - registeredInstances:[{}].", (Object)this.registeredInstanceIds.size());
        }
        for (NamespacedInstanceId registeredInstance : this.registeredInstanceIds) {
            try {
                this.machineIdDistributor.guard(registeredInstance.getNamespace(), registeredInstance.getInstanceId(), this.safeGuardDuration);
            }
            catch (Throwable throwable) {
                if (!log.isErrorEnabled()) continue;
                log.error("Guard Failed:[{}]!", (Object)throwable.getMessage(), (Object)throwable);
            }
        }
    }

    @Override
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug("stop - registeredInstances:[{}].", (Object)this.registeredInstanceIds.size());
        }
        if (this.running.compareAndSet(true, false)) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }
}

