/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.exception.ClockTooManyBackwardsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClockBackwardsSynchronizer
implements ClockBackwardsSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(DefaultClockBackwardsSynchronizer.class);
    public static final int DEFAULT_SPIN_THRESHOLD = 1;
    public static final int DEFAULT_BROKEN_THRESHOLD = 500;
    private final int spinThreshold;
    private final int brokenThreshold;

    public DefaultClockBackwardsSynchronizer() {
        this(1, 500);
    }

    public DefaultClockBackwardsSynchronizer(int spinThreshold, int brokenThreshold) {
        Preconditions.checkArgument((spinThreshold > 0 ? 1 : 0) != 0, (String)"spinThreshold:[%s] must be greater than 0!", (int)spinThreshold);
        Preconditions.checkArgument((brokenThreshold > spinThreshold ? 1 : 0) != 0, (String)"spinThreshold:[%s] must be greater than brokenThreshold:[%s]!", (int)spinThreshold, (int)brokenThreshold);
        this.spinThreshold = spinThreshold;
        this.brokenThreshold = brokenThreshold;
    }

    @Override
    public void sync(long lastTimestamp) throws InterruptedException, ClockTooManyBackwardsException {
        long backwardsStamp = ClockBackwardsSynchronizer.getBackwardsTimeStamp(lastTimestamp);
        if (backwardsStamp <= 0L) {
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("sync - backwardsStamp:[{}] - lastStamp:[{}].", (Object)backwardsStamp, (Object)lastTimestamp);
        }
        if (backwardsStamp <= (long)this.spinThreshold) {
            while (ClockBackwardsSynchronizer.getBackwardsTimeStamp(lastTimestamp) > 0L) {
            }
            return;
        }
        if (backwardsStamp > (long)this.brokenThreshold) {
            throw new ClockTooManyBackwardsException(lastTimestamp, System.currentTimeMillis(), this.brokenThreshold);
        }
        TimeUnit.MILLISECONDS.sleep(backwardsStamp);
    }

    @Override
    public void syncUninterruptibly(long lastTimestamp) throws ClockTooManyBackwardsException {
        try {
            this.sync(lastTimestamp);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CosIdException(e);
        }
    }
}

