/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import com.google.common.base.Strings;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.exception.ClockBackwardsException;
import me.ahoo.cosid.snowflake.exception.TimestampOverflowException;

public abstract class AbstractSnowflakeId
implements SnowflakeId {
    protected final long epoch;
    protected final int timestampBit;
    protected final int machineBit;
    protected final int sequenceBit;
    protected final long maxTimestamp;
    protected final long maxSequence;
    protected final long maxMachine;
    protected final long machineLeft;
    protected final long timestampLeft;
    protected final long machineId;
    protected long sequence = 0L;
    protected long lastTimestamp = -1L;

    public AbstractSnowflakeId(long epoch, int timestampBit, int machineBit, int sequenceBit, long machineId) {
        if (timestampBit + machineBit + sequenceBit > 63) {
            throw new IllegalArgumentException("total bit can't be greater than TOTAL_BIT[63] .");
        }
        this.epoch = epoch;
        this.timestampBit = timestampBit;
        this.machineBit = machineBit;
        this.sequenceBit = sequenceBit;
        this.maxTimestamp = -1L << timestampBit ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxSequence = -1L << sequenceBit ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxMachine = -1L << machineBit ^ 0xFFFFFFFFFFFFFFFFL;
        this.machineLeft = sequenceBit;
        this.timestampLeft = this.machineLeft + (long)machineBit;
        if (machineId > this.maxMachine || machineId < 0L) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"machineId can't be greater than maxMachine[%s] or less than 0 .", (Object[])new Object[]{this.maxMachine}));
        }
        this.machineId = machineId;
    }

    protected long nextTime() {
        long time = this.getCurrentTime();
        while (time <= this.lastTimestamp) {
            time = this.getCurrentTime();
        }
        return time;
    }

    protected abstract long getCurrentTime();

    @Override
    public synchronized long generate() {
        long currentTimestamp = this.getCurrentTime();
        if (currentTimestamp < this.lastTimestamp) {
            throw new ClockBackwardsException(this.lastTimestamp, currentTimestamp);
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & this.maxSequence;
            if (this.sequence == 0L) {
                currentTimestamp = this.nextTime();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        long diffTimestamp = currentTimestamp - this.epoch;
        if (diffTimestamp > this.maxTimestamp) {
            throw new TimestampOverflowException(this.epoch, diffTimestamp, this.maxTimestamp);
        }
        return diffTimestamp << (int)this.timestampLeft | this.machineId << (int)this.machineLeft | this.sequence;
    }

    @Override
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    public int getTimestampBit() {
        return this.timestampBit;
    }

    @Override
    public int getMachineBit() {
        return this.machineBit;
    }

    @Override
    public int getSequenceBit() {
        return this.sequenceBit;
    }

    @Override
    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public long getMaxMachine() {
        return this.maxMachine;
    }

    @Override
    public long getMaxSequence() {
        return this.maxSequence;
    }

    @Override
    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public long getMachineId() {
        return this.machineId;
    }
}

