/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment.concurrent;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import me.ahoo.cosid.segment.concurrent.AffinityJob;
import me.ahoo.cosid.segment.concurrent.DefaultPrefetchWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchWorkerExecutorService {
    private static final Logger log = LoggerFactory.getLogger(PrefetchWorkerExecutorService.class);
    public static final Duration DEFAULT_PREFETCH_PERIOD = Duration.ofSeconds(1L);
    public static final PrefetchWorkerExecutorService DEFAULT = new PrefetchWorkerExecutorService(DEFAULT_PREFETCH_PERIOD, Runtime.getRuntime().availableProcessors());
    private volatile boolean shutdown = false;
    private final int corePoolSize;
    private final Duration prefetchPeriod;
    private final DefaultPrefetchWorker[] workers;
    private boolean initialized = false;
    private final AtomicLong threadIdx = new AtomicLong();

    public PrefetchWorkerExecutorService(Duration prefetchPeriod, int corePoolSize) {
        this(prefetchPeriod, corePoolSize, true);
    }

    public PrefetchWorkerExecutorService(Duration prefetchPeriod, int corePoolSize, boolean shutdownHook) {
        Preconditions.checkArgument((corePoolSize > 0 ? 1 : 0) != 0, (String)"corePoolSize:[%s] must be greater than 0.", (int)corePoolSize);
        this.prefetchPeriod = prefetchPeriod;
        this.corePoolSize = corePoolSize;
        this.workers = new DefaultPrefetchWorker[corePoolSize];
        if (shutdownHook) {
            Runtime.getRuntime().addShutdownHook(new GracefullyCloser());
        }
    }

    private void ensureInitWorkers() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (int i = 0; i < this.corePoolSize; ++i) {
            DefaultPrefetchWorker prefetchWorker = new DefaultPrefetchWorker(this.prefetchPeriod);
            prefetchWorker.setDaemon(true);
            this.workers[i] = prefetchWorker;
            if (!log.isDebugEnabled()) continue;
            log.debug("initWorkers - [{}].", (Object)prefetchWorker.getName());
        }
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info("shutdown!");
        }
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (DefaultPrefetchWorker worker : this.workers) {
            if (worker == null) continue;
            worker.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(AffinityJob affinityJob) {
        Preconditions.checkNotNull((Object)affinityJob, (Object)"affinityJob can not be null!");
        if (log.isInfoEnabled()) {
            log.info("submit - jobId:[{}].", (Object)affinityJob.getJobId());
        }
        if (this.shutdown) {
            throw new IllegalStateException("PrefetchWorkerExecutorService is shutdown.");
        }
        if (affinityJob.getPrefetchWorker() != null) {
            return;
        }
        PrefetchWorkerExecutorService prefetchWorkerExecutorService = this;
        synchronized (prefetchWorkerExecutorService) {
            if (affinityJob.getPrefetchWorker() != null) {
                return;
            }
            this.ensureInitWorkers();
            DefaultPrefetchWorker prefetchWorker = this.chooseWorker();
            if (log.isInfoEnabled()) {
                log.info("submit - jobId:[{}] is bound to thread:[{}].", (Object)affinityJob.getJobId(), (Object)prefetchWorker.getName());
            }
            if (Thread.State.NEW.equals((Object)prefetchWorker.getState())) {
                if (log.isInfoEnabled()) {
                    log.info("submit - jobId:[{}] is bound to thread:[{}] start.", (Object)affinityJob.getJobId(), (Object)prefetchWorker.getName());
                }
                prefetchWorker.start();
            }
            prefetchWorker.submit(affinityJob);
            affinityJob.setPrefetchWorker(prefetchWorker);
        }
    }

    private DefaultPrefetchWorker chooseWorker() {
        return this.workers[(int)Math.abs(this.threadIdx.getAndIncrement() % (long)this.workers.length)];
    }

    public class GracefullyCloser
    extends Thread {
        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info("Close gracefully!");
            }
            PrefetchWorkerExecutorService.this.shutdown();
        }
    }
}

